/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apigateway.model.UpdateApiDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateApiRequest
extends BmcRequest<UpdateApiDetails> {
    private String apiId;
    private UpdateApiDetails updateApiDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public UpdateApiDetails getBody$() {
        return this.updateApiDetails;
    }

    @ConstructorProperties(value={"apiId", "updateApiDetails", "ifMatch", "opcRequestId"})
    UpdateApiRequest(String apiId, UpdateApiDetails updateApiDetails, String ifMatch, String opcRequestId) {
        this.apiId = apiId;
        this.updateApiDetails = updateApiDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApiId() {
        return this.apiId;
    }

    public UpdateApiDetails getUpdateApiDetails() {
        return this.updateApiDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateApiRequest, UpdateApiDetails> {
        private String apiId;
        private UpdateApiDetails updateApiDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateApiRequest o) {
            this.apiId(o.getApiId());
            this.updateApiDetails(o.getUpdateApiDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateApiRequest build() {
            UpdateApiRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateApiDetails body) {
            this.updateApiDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public Builder updateApiDetails(UpdateApiDetails updateApiDetails) {
            this.updateApiDetails = updateApiDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateApiRequest buildWithoutInvocationCallback() {
            return new UpdateApiRequest(this.apiId, this.updateApiDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateApiRequest.Builder(apiId=" + this.apiId + ", updateApiDetails=" + this.updateApiDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

