/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apmsynthetics.ApmSynthetic;
import com.oracle.bmc.apmsynthetics.model.MonitorSummary;
import com.oracle.bmc.apmsynthetics.model.PublicVantagePointSummary;
import com.oracle.bmc.apmsynthetics.model.ScriptSummary;
import com.oracle.bmc.apmsynthetics.requests.ListMonitorsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListPublicVantagePointsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListScriptsRequest;
import com.oracle.bmc.apmsynthetics.responses.ListMonitorsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListPublicVantagePointsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListScriptsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ApmSyntheticPaginators {
    private final ApmSynthetic client;

    public Iterable<ListMonitorsResponse> listMonitorsResponseIterator(final ListMonitorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMonitorsRequest.Builder>(){

            public ListMonitorsRequest.Builder get() {
                return ListMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMonitorsResponse, String>(){

            public String apply(ListMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMonitorsRequest.Builder>, ListMonitorsRequest>(){

            public ListMonitorsRequest apply(RequestBuilderAndToken<ListMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMonitorsRequest, ListMonitorsResponse>(){

            public ListMonitorsResponse apply(ListMonitorsRequest request) {
                return ApmSyntheticPaginators.this.client.listMonitors(request);
            }
        });
    }

    public Iterable<MonitorSummary> listMonitorsRecordIterator(final ListMonitorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMonitorsRequest.Builder>(){

            public ListMonitorsRequest.Builder get() {
                return ListMonitorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMonitorsResponse, String>(){

            public String apply(ListMonitorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMonitorsRequest.Builder>, ListMonitorsRequest>(){

            public ListMonitorsRequest apply(RequestBuilderAndToken<ListMonitorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMonitorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMonitorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMonitorsRequest, ListMonitorsResponse>(){

            public ListMonitorsResponse apply(ListMonitorsRequest request) {
                return ApmSyntheticPaginators.this.client.listMonitors(request);
            }
        }, (Function)new Function<ListMonitorsResponse, List<MonitorSummary>>(){

            public List<MonitorSummary> apply(ListMonitorsResponse response) {
                return response.getMonitorCollection().getItems();
            }
        });
    }

    public Iterable<ListPublicVantagePointsResponse> listPublicVantagePointsResponseIterator(final ListPublicVantagePointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublicVantagePointsRequest.Builder>(){

            public ListPublicVantagePointsRequest.Builder get() {
                return ListPublicVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicVantagePointsResponse, String>(){

            public String apply(ListPublicVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicVantagePointsRequest.Builder>, ListPublicVantagePointsRequest>(){

            public ListPublicVantagePointsRequest apply(RequestBuilderAndToken<ListPublicVantagePointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicVantagePointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse>(){

            public ListPublicVantagePointsResponse apply(ListPublicVantagePointsRequest request) {
                return ApmSyntheticPaginators.this.client.listPublicVantagePoints(request);
            }
        });
    }

    public Iterable<PublicVantagePointSummary> listPublicVantagePointsRecordIterator(final ListPublicVantagePointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublicVantagePointsRequest.Builder>(){

            public ListPublicVantagePointsRequest.Builder get() {
                return ListPublicVantagePointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublicVantagePointsResponse, String>(){

            public String apply(ListPublicVantagePointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublicVantagePointsRequest.Builder>, ListPublicVantagePointsRequest>(){

            public ListPublicVantagePointsRequest apply(RequestBuilderAndToken<ListPublicVantagePointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublicVantagePointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublicVantagePointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse>(){

            public ListPublicVantagePointsResponse apply(ListPublicVantagePointsRequest request) {
                return ApmSyntheticPaginators.this.client.listPublicVantagePoints(request);
            }
        }, (Function)new Function<ListPublicVantagePointsResponse, List<PublicVantagePointSummary>>(){

            public List<PublicVantagePointSummary> apply(ListPublicVantagePointsResponse response) {
                return response.getPublicVantagePointCollection().getItems();
            }
        });
    }

    public Iterable<ListScriptsResponse> listScriptsResponseIterator(final ListScriptsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListScriptsRequest.Builder>(){

            public ListScriptsRequest.Builder get() {
                return ListScriptsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScriptsResponse, String>(){

            public String apply(ListScriptsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScriptsRequest.Builder>, ListScriptsRequest>(){

            public ListScriptsRequest apply(RequestBuilderAndToken<ListScriptsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListScriptsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScriptsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListScriptsRequest, ListScriptsResponse>(){

            public ListScriptsResponse apply(ListScriptsRequest request) {
                return ApmSyntheticPaginators.this.client.listScripts(request);
            }
        });
    }

    public Iterable<ScriptSummary> listScriptsRecordIterator(final ListScriptsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListScriptsRequest.Builder>(){

            public ListScriptsRequest.Builder get() {
                return ListScriptsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScriptsResponse, String>(){

            public String apply(ListScriptsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScriptsRequest.Builder>, ListScriptsRequest>(){

            public ListScriptsRequest apply(RequestBuilderAndToken<ListScriptsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListScriptsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScriptsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListScriptsRequest, ListScriptsResponse>(){

            public ListScriptsResponse apply(ListScriptsRequest request) {
                return ApmSyntheticPaginators.this.client.listScripts(request);
            }
        }, (Function)new Function<ListScriptsResponse, List<ScriptSummary>>(){

            public List<ScriptSummary> apply(ListScriptsResponse response) {
                return response.getScriptCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ApmSyntheticPaginators(ApmSynthetic client) {
        this.client = client;
    }
}

