/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetScriptRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String scriptId;
    private String opcRequestId;

    @ConstructorProperties(value={"apmDomainId", "scriptId", "opcRequestId"})
    GetScriptRequest(String apmDomainId, String scriptId, String opcRequestId) {
        this.apmDomainId = apmDomainId;
        this.scriptId = scriptId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetScriptRequest, Void> {
        private String apmDomainId;
        private String scriptId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetScriptRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.scriptId(o.getScriptId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetScriptRequest build() {
            GetScriptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetScriptRequest buildWithoutInvocationCallback() {
            return new GetScriptRequest(this.apmDomainId, this.scriptId, this.opcRequestId);
        }

        public String toString() {
            return "GetScriptRequest.Builder(apmDomainId=" + this.apmDomainId + ", scriptId=" + this.scriptId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

