/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmsynthetics.model.MonitorStatus;
import com.oracle.bmc.apmsynthetics.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListMonitorsRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String displayName;
    private String scriptId;
    private String monitorType;
    private MonitorStatus status;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"apmDomainId", "displayName", "scriptId", "monitorType", "status", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListMonitorsRequest(String apmDomainId, String displayName, String scriptId, String monitorType, MonitorStatus status, Integer limit, String page, SortOrders sortOrder, SortBy sortBy, String opcRequestId) {
        this.apmDomainId = apmDomainId;
        this.displayName = displayName;
        this.scriptId = scriptId;
        this.monitorType = monitorType;
        this.status = status;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public MonitorStatus getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMonitorsRequest, Void> {
        private String apmDomainId;
        private String displayName;
        private String scriptId;
        private String monitorType;
        private MonitorStatus status;
        private Integer limit;
        private String page;
        private SortOrders sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMonitorsRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.displayName(o.getDisplayName());
            this.scriptId(o.getScriptId());
            this.monitorType(o.getMonitorType());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMonitorsRequest build() {
            ListMonitorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public Builder monitorType(String monitorType) {
            this.monitorType = monitorType;
            return this;
        }

        public Builder status(MonitorStatus status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListMonitorsRequest buildWithoutInvocationCallback() {
            return new ListMonitorsRequest(this.apmDomainId, this.displayName, this.scriptId, this.monitorType, this.status, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListMonitorsRequest.Builder(apmDomainId=" + this.apmDomainId + ", displayName=" + this.displayName + ", scriptId=" + this.scriptId + ", monitorType=" + this.monitorType + ", status=" + (Object)((Object)this.status) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Status("status"),
        MonitorType("monitorType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

