/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apmtraces.model.Span;
import com.oracle.bmc.apmtraces.requests.GetSpanRequest;
import com.oracle.bmc.apmtraces.responses.GetSpanResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSpanConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetSpanConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetSpanRequest interceptRequest(GetSpanRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetSpanRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getApmDomainId(), (String)"apmDomainId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSpanKey(), (String)"spanKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("spans").path(HttpUtils.encodePathSegment((String)request.getTraceKey())).path(HttpUtils.encodePathSegment((String)request.getSpanKey()));
        target = target.queryParam("apmDomainId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getApmDomainId())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetSpanResponse> fromResponse() {
        Function<Response, GetSpanResponse> transformer = new Function<Response, GetSpanResponse>(){

            public GetSpanResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.apmtraces.responses.GetSpanResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Span.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetSpanResponse.Builder builder = GetSpanResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.span((Span)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetSpanResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

