/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apmtraces.model.QueryResultResponse;
import com.oracle.bmc.apmtraces.requests.QueryRequest;
import com.oracle.bmc.apmtraces.responses.QueryResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(QueryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static QueryRequest interceptRequest(QueryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, QueryRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getApmDomainId(), (String)"apmDomainId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTimeSpanStartedGreaterThanOrEqualTo(), (String)"timeSpanStartedGreaterThanOrEqualTo is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTimeSpanStartedLessThan(), (String)"timeSpanStartedLessThan is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getQueryDetails(), (String)"queryDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("queries").path("actions").path("runQuery");
        target = target.queryParam("apmDomainId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getApmDomainId())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        target = target.queryParam("timeSpanStartedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeSpanStartedGreaterThanOrEqualTo())});
        target = target.queryParam("timeSpanStartedLessThan", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeSpanStartedLessThan())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, QueryResponse> fromResponse() {
        Function<Response, QueryResponse> transformer = new Function<Response, QueryResponse>(){

            public QueryResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                Optional opcTotalItemsHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.apmtraces.responses.QueryResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(QueryResultResponse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                QueryResponse.Builder builder = QueryResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.queryResultResponse((QueryResultResponse)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-total-items")).isPresent()) {
                    builder.opcTotalItems((Integer)HeaderUtils.toValue((String)"opc-total-items", (String)((String)((List)opcTotalItemsHeader.get()).get(0)), Integer.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                QueryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

