/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSpanRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String spanKey;
    private String traceKey;
    private String opcRequestId;

    @ConstructorProperties(value={"apmDomainId", "spanKey", "traceKey", "opcRequestId"})
    GetSpanRequest(String apmDomainId, String spanKey, String traceKey, String opcRequestId) {
        this.apmDomainId = apmDomainId;
        this.spanKey = spanKey;
        this.traceKey = traceKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getSpanKey() {
        return this.spanKey;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSpanRequest, Void> {
        private String apmDomainId;
        private String spanKey;
        private String traceKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSpanRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.spanKey(o.getSpanKey());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSpanRequest build() {
            GetSpanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder spanKey(String spanKey) {
            this.spanKey = spanKey;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSpanRequest buildWithoutInvocationCallback() {
            return new GetSpanRequest(this.apmDomainId, this.spanKey, this.traceKey, this.opcRequestId);
        }

        public String toString() {
            return "GetSpanRequest.Builder(apmDomainId=" + this.apmDomainId + ", spanKey=" + this.spanKey + ", traceKey=" + this.traceKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

