/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTraceRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String traceKey;
    private String opcRequestId;

    @ConstructorProperties(value={"apmDomainId", "traceKey", "opcRequestId"})
    GetTraceRequest(String apmDomainId, String traceKey, String opcRequestId) {
        this.apmDomainId = apmDomainId;
        this.traceKey = traceKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTraceRequest, Void> {
        private String apmDomainId;
        private String traceKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTraceRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.traceKey(o.getTraceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTraceRequest build() {
            GetTraceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder traceKey(String traceKey) {
            this.traceKey = traceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTraceRequest buildWithoutInvocationCallback() {
            return new GetTraceRequest(this.apmDomainId, this.traceKey, this.opcRequestId);
        }

        public String toString() {
            return "GetTraceRequest.Builder(apmDomainId=" + this.apmDomainId + ", traceKey=" + this.traceKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

