/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.applicationmigration.ApplicationMigrationAsync;
import com.oracle.bmc.applicationmigration.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.applicationmigration.internal.http.ChangeMigrationCompartmentConverter;
import com.oracle.bmc.applicationmigration.internal.http.ChangeSourceCompartmentConverter;
import com.oracle.bmc.applicationmigration.internal.http.CreateMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.CreateSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.DeleteMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.DeleteSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetSourceConverter;
import com.oracle.bmc.applicationmigration.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListMigrationsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListSourceApplicationsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListSourcesConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.applicationmigration.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.applicationmigration.internal.http.MigrateApplicationConverter;
import com.oracle.bmc.applicationmigration.internal.http.UpdateMigrationConverter;
import com.oracle.bmc.applicationmigration.internal.http.UpdateSourceConverter;
import com.oracle.bmc.applicationmigration.requests.CancelWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.ChangeSourceCompartmentRequest;
import com.oracle.bmc.applicationmigration.requests.CreateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.CreateSourceRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.DeleteSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.GetSourceRequest;
import com.oracle.bmc.applicationmigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.requests.MigrateApplicationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.applicationmigration.requests.UpdateSourceRequest;
import com.oracle.bmc.applicationmigration.responses.CancelWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.ChangeSourceCompartmentResponse;
import com.oracle.bmc.applicationmigration.responses.CreateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.CreateSourceResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.DeleteSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.GetSourceResponse;
import com.oracle.bmc.applicationmigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.applicationmigration.responses.MigrateApplicationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.applicationmigration.responses.UpdateSourceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMigrationAsyncClient
implements ApplicationMigrationAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMigrationAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONMIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://applicationmigration.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ApplicationMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApplicationMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApplicationMigrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApplicationMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApplicationMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApplicationMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApplicationMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ApplicationMigrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeMigrationCompartmentResponse> changeMigrationCompartment(ChangeMigrationCompartmentRequest request, AsyncHandler<ChangeMigrationCompartmentRequest, ChangeMigrationCompartmentResponse> handler) {
        LOG.trace("Called async changeMigrationCompartment");
        ChangeMigrationCompartmentRequest interceptedRequest = ChangeMigrationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeMigrationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeMigrationCompartmentResponse> transformer = ChangeMigrationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeMigrationCompartmentRequest, ChangeMigrationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeMigrationCompartmentRequest, ChangeMigrationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeSourceCompartmentResponse> changeSourceCompartment(ChangeSourceCompartmentRequest request, AsyncHandler<ChangeSourceCompartmentRequest, ChangeSourceCompartmentResponse> handler) {
        LOG.trace("Called async changeSourceCompartment");
        ChangeSourceCompartmentRequest interceptedRequest = ChangeSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSourceCompartmentResponse> transformer = ChangeSourceCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeSourceCompartmentRequest, ChangeSourceCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSourceCompartmentRequest, ChangeSourceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateMigrationResponse> createMigration(CreateMigrationRequest request, AsyncHandler<CreateMigrationRequest, CreateMigrationResponse> handler) {
        LOG.trace("Called async createMigration");
        CreateMigrationRequest interceptedRequest = CreateMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMigrationResponse> transformer = CreateMigrationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateMigrationRequest, CreateMigrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateMigrationRequest, CreateMigrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSourceResponse> createSource(CreateSourceRequest request, AsyncHandler<CreateSourceRequest, CreateSourceResponse> handler) {
        LOG.trace("Called async createSource");
        CreateSourceRequest interceptedRequest = CreateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSourceResponse> transformer = CreateSourceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSourceRequest, CreateSourceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSourceRequest, CreateSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteMigrationResponse> deleteMigration(DeleteMigrationRequest request, AsyncHandler<DeleteMigrationRequest, DeleteMigrationResponse> handler) {
        LOG.trace("Called async deleteMigration");
        DeleteMigrationRequest interceptedRequest = DeleteMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteMigrationResponse> transformer = DeleteMigrationConverter.fromResponse();
        AsyncHandler<DeleteMigrationRequest, DeleteMigrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteMigrationRequest, DeleteMigrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSourceResponse> deleteSource(DeleteSourceRequest request, AsyncHandler<DeleteSourceRequest, DeleteSourceResponse> handler) {
        LOG.trace("Called async deleteSource");
        DeleteSourceRequest interceptedRequest = DeleteSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSourceResponse> transformer = DeleteSourceConverter.fromResponse();
        AsyncHandler<DeleteSourceRequest, DeleteSourceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSourceRequest, DeleteSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMigrationResponse> getMigration(GetMigrationRequest request, AsyncHandler<GetMigrationRequest, GetMigrationResponse> handler) {
        LOG.trace("Called async getMigration");
        GetMigrationRequest interceptedRequest = GetMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMigrationResponse> transformer = GetMigrationConverter.fromResponse();
        AsyncHandler<GetMigrationRequest, GetMigrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMigrationRequest, GetMigrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSourceResponse> getSource(GetSourceRequest request, AsyncHandler<GetSourceRequest, GetSourceResponse> handler) {
        LOG.trace("Called async getSource");
        GetSourceRequest interceptedRequest = GetSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSourceResponse> transformer = GetSourceConverter.fromResponse();
        AsyncHandler<GetSourceRequest, GetSourceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSourceRequest, GetSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMigrationsResponse> listMigrations(ListMigrationsRequest request, AsyncHandler<ListMigrationsRequest, ListMigrationsResponse> handler) {
        LOG.trace("Called async listMigrations");
        ListMigrationsRequest interceptedRequest = ListMigrationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMigrationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMigrationsResponse> transformer = ListMigrationsConverter.fromResponse();
        AsyncHandler<ListMigrationsRequest, ListMigrationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMigrationsRequest, ListMigrationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourceApplicationsResponse> listSourceApplications(ListSourceApplicationsRequest request, AsyncHandler<ListSourceApplicationsRequest, ListSourceApplicationsResponse> handler) {
        LOG.trace("Called async listSourceApplications");
        ListSourceApplicationsRequest interceptedRequest = ListSourceApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceApplicationsResponse> transformer = ListSourceApplicationsConverter.fromResponse();
        AsyncHandler<ListSourceApplicationsRequest, ListSourceApplicationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourceApplicationsRequest, ListSourceApplicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourcesResponse> listSources(ListSourcesRequest request, AsyncHandler<ListSourcesRequest, ListSourcesResponse> handler) {
        LOG.trace("Called async listSources");
        ListSourcesRequest interceptedRequest = ListSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourcesResponse> transformer = ListSourcesConverter.fromResponse();
        AsyncHandler<ListSourcesRequest, ListSourcesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourcesRequest, ListSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<MigrateApplicationResponse> migrateApplication(MigrateApplicationRequest request, AsyncHandler<MigrateApplicationRequest, MigrateApplicationResponse> handler) {
        LOG.trace("Called async migrateApplication");
        MigrateApplicationRequest interceptedRequest = MigrateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MigrateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, MigrateApplicationResponse> transformer = MigrateApplicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<MigrateApplicationRequest, MigrateApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<MigrateApplicationRequest, MigrateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateMigrationResponse> updateMigration(UpdateMigrationRequest request, AsyncHandler<UpdateMigrationRequest, UpdateMigrationResponse> handler) {
        LOG.trace("Called async updateMigration");
        UpdateMigrationRequest interceptedRequest = UpdateMigrationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMigrationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMigrationResponse> transformer = UpdateMigrationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateMigrationRequest, UpdateMigrationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateMigrationRequest, UpdateMigrationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSourceResponse> updateSource(UpdateSourceRequest request, AsyncHandler<UpdateSourceRequest, UpdateSourceResponse> handler) {
        LOG.trace("Called async updateSource");
        UpdateSourceRequest interceptedRequest = UpdateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSourceResponse> transformer = UpdateSourceConverter.fromResponse();
        AsyncHandler<UpdateSourceRequest, UpdateSourceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSourceRequest, UpdateSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationMigrationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApplicationMigrationAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApplicationMigrationAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

