/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.applicationmigration.ApplicationMigration;
import com.oracle.bmc.applicationmigration.model.MigrationSummary;
import com.oracle.bmc.applicationmigration.model.SourceApplicationSummary;
import com.oracle.bmc.applicationmigration.model.SourceSummary;
import com.oracle.bmc.applicationmigration.model.WorkRequestError;
import com.oracle.bmc.applicationmigration.model.WorkRequestLogEntry;
import com.oracle.bmc.applicationmigration.model.WorkRequestSummary;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ApplicationMigrationPaginators {
    private final ApplicationMigration client;

    public Iterable<ListMigrationsResponse> listMigrationsResponseIterator(final ListMigrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listMigrations(request);
            }
        });
    }

    public Iterable<MigrationSummary> listMigrationsRecordIterator(final ListMigrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listMigrations(request);
            }
        }, (Function)new Function<ListMigrationsResponse, List<MigrationSummary>>(){

            public List<MigrationSummary> apply(ListMigrationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSourceApplicationsResponse> listSourceApplicationsResponseIterator(final ListSourceApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSourceApplicationsRequest.Builder>(){

            public ListSourceApplicationsRequest.Builder get() {
                return ListSourceApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, String>(){

            public String apply(ListSourceApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourceApplicationsRequest.Builder>, ListSourceApplicationsRequest>(){

            public ListSourceApplicationsRequest apply(RequestBuilderAndToken<ListSourceApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSourceApplicationsRequest, ListSourceApplicationsResponse>(){

            public ListSourceApplicationsResponse apply(ListSourceApplicationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listSourceApplications(request);
            }
        });
    }

    public Iterable<SourceApplicationSummary> listSourceApplicationsRecordIterator(final ListSourceApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSourceApplicationsRequest.Builder>(){

            public ListSourceApplicationsRequest.Builder get() {
                return ListSourceApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, String>(){

            public String apply(ListSourceApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourceApplicationsRequest.Builder>, ListSourceApplicationsRequest>(){

            public ListSourceApplicationsRequest apply(RequestBuilderAndToken<ListSourceApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSourceApplicationsRequest, ListSourceApplicationsResponse>(){

            public ListSourceApplicationsResponse apply(ListSourceApplicationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listSourceApplications(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, List<SourceApplicationSummary>>(){

            public List<SourceApplicationSummary> apply(ListSourceApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSourcesResponse> listSourcesResponseIterator(final ListSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSourcesRequest.Builder>(){

            public ListSourcesRequest.Builder get() {
                return ListSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourcesResponse, String>(){

            public String apply(ListSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourcesRequest.Builder>, ListSourcesRequest>(){

            public ListSourcesRequest apply(RequestBuilderAndToken<ListSourcesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourcesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSourcesRequest, ListSourcesResponse>(){

            public ListSourcesResponse apply(ListSourcesRequest request) {
                return ApplicationMigrationPaginators.this.client.listSources(request);
            }
        });
    }

    public Iterable<SourceSummary> listSourcesRecordIterator(final ListSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSourcesRequest.Builder>(){

            public ListSourcesRequest.Builder get() {
                return ListSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourcesResponse, String>(){

            public String apply(ListSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourcesRequest.Builder>, ListSourcesRequest>(){

            public ListSourcesRequest apply(RequestBuilderAndToken<ListSourcesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourcesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSourcesRequest, ListSourcesResponse>(){

            public ListSourcesResponse apply(ListSourcesRequest request) {
                return ApplicationMigrationPaginators.this.client.listSources(request);
            }
        }, (Function)new Function<ListSourcesResponse, List<SourceSummary>>(){

            public List<SourceSummary> apply(ListSourcesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ApplicationMigrationPaginators(ApplicationMigration client) {
        this.client = client;
    }
}

