/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.artifacts.Artifacts;
import com.oracle.bmc.artifacts.ArtifactsPaginators;
import com.oracle.bmc.artifacts.ArtifactsWaiters;
import com.oracle.bmc.artifacts.internal.http.ChangeContainerRepositoryCompartmentConverter;
import com.oracle.bmc.artifacts.internal.http.CreateContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.DeleteContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.DeleteContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerConfigurationConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.GetContainerRepositoryConverter;
import com.oracle.bmc.artifacts.internal.http.ListContainerImagesConverter;
import com.oracle.bmc.artifacts.internal.http.ListContainerRepositoriesConverter;
import com.oracle.bmc.artifacts.internal.http.RemoveContainerVersionConverter;
import com.oracle.bmc.artifacts.internal.http.RestoreContainerImageConverter;
import com.oracle.bmc.artifacts.internal.http.UpdateContainerConfigurationConverter;
import com.oracle.bmc.artifacts.internal.http.UpdateContainerRepositoryConverter;
import com.oracle.bmc.artifacts.requests.ChangeContainerRepositoryCompartmentRequest;
import com.oracle.bmc.artifacts.requests.CreateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerImageRequest;
import com.oracle.bmc.artifacts.requests.DeleteContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.GetContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.GetContainerImageRequest;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.requests.RemoveContainerVersionRequest;
import com.oracle.bmc.artifacts.requests.RestoreContainerImageRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerConfigurationRequest;
import com.oracle.bmc.artifacts.requests.UpdateContainerRepositoryRequest;
import com.oracle.bmc.artifacts.responses.ChangeContainerRepositoryCompartmentResponse;
import com.oracle.bmc.artifacts.responses.CreateContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerImageResponse;
import com.oracle.bmc.artifacts.responses.DeleteContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.GetContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.GetContainerImageResponse;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerRepositoriesResponse;
import com.oracle.bmc.artifacts.responses.RemoveContainerVersionResponse;
import com.oracle.bmc.artifacts.responses.RestoreContainerImageResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerConfigurationResponse;
import com.oracle.bmc.artifacts.responses.UpdateContainerRepositoryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactsClient
implements Artifacts {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ARTIFACTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://artifacts.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ArtifactsWaiters waiters;
    private final ArtifactsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ArtifactsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ArtifactsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ArtifactsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ArtifactsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Artifacts-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ArtifactsWaiters(executorService, this);
        this.paginators = new ArtifactsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeContainerRepositoryCompartmentResponse changeContainerRepositoryCompartment(ChangeContainerRepositoryCompartmentRequest request) {
        LOG.trace("Called changeContainerRepositoryCompartment");
        ChangeContainerRepositoryCompartmentRequest interceptedRequest = ChangeContainerRepositoryCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeContainerRepositoryCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeContainerRepositoryCompartmentResponse> transformer = ChangeContainerRepositoryCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeContainerRepositoryCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeContainerRepositoryCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeContainerRepositoryCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeContainerRepositoryCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateContainerRepositoryResponse createContainerRepository(CreateContainerRepositoryRequest request) {
        LOG.trace("Called createContainerRepository");
        CreateContainerRepositoryRequest interceptedRequest = CreateContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateContainerRepositoryResponse> transformer = CreateContainerRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateContainerRepositoryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateContainerRepositoryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateContainerRepositoryDetails(), (BmcRequest)retriedRequest);
                return (CreateContainerRepositoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteContainerImageResponse deleteContainerImage(DeleteContainerImageRequest request) {
        LOG.trace("Called deleteContainerImage");
        DeleteContainerImageRequest interceptedRequest = DeleteContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteContainerImageResponse> transformer = DeleteContainerImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteContainerImageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteContainerImageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteContainerImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteContainerRepositoryResponse deleteContainerRepository(DeleteContainerRepositoryRequest request) {
        LOG.trace("Called deleteContainerRepository");
        DeleteContainerRepositoryRequest interceptedRequest = DeleteContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteContainerRepositoryResponse> transformer = DeleteContainerRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteContainerRepositoryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteContainerRepositoryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteContainerRepositoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetContainerConfigurationResponse getContainerConfiguration(GetContainerConfigurationRequest request) {
        LOG.trace("Called getContainerConfiguration");
        GetContainerConfigurationRequest interceptedRequest = GetContainerConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerConfigurationResponse> transformer = GetContainerConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetContainerConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetContainerConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetContainerConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetContainerImageResponse getContainerImage(GetContainerImageRequest request) {
        LOG.trace("Called getContainerImage");
        GetContainerImageRequest interceptedRequest = GetContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerImageResponse> transformer = GetContainerImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetContainerImageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetContainerImageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetContainerImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetContainerRepositoryResponse getContainerRepository(GetContainerRepositoryRequest request) {
        LOG.trace("Called getContainerRepository");
        GetContainerRepositoryRequest interceptedRequest = GetContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetContainerRepositoryResponse> transformer = GetContainerRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetContainerRepositoryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetContainerRepositoryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetContainerRepositoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListContainerImagesResponse listContainerImages(ListContainerImagesRequest request) {
        LOG.trace("Called listContainerImages");
        ListContainerImagesRequest interceptedRequest = ListContainerImagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListContainerImagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListContainerImagesResponse> transformer = ListContainerImagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListContainerImagesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListContainerImagesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListContainerImagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListContainerRepositoriesResponse listContainerRepositories(ListContainerRepositoriesRequest request) {
        LOG.trace("Called listContainerRepositories");
        ListContainerRepositoriesRequest interceptedRequest = ListContainerRepositoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListContainerRepositoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListContainerRepositoriesResponse> transformer = ListContainerRepositoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListContainerRepositoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListContainerRepositoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListContainerRepositoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveContainerVersionResponse removeContainerVersion(RemoveContainerVersionRequest request) {
        LOG.trace("Called removeContainerVersion");
        RemoveContainerVersionRequest interceptedRequest = RemoveContainerVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveContainerVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveContainerVersionResponse> transformer = RemoveContainerVersionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveContainerVersionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveContainerVersionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemoveContainerVersionDetails(), (BmcRequest)retriedRequest);
                return (RemoveContainerVersionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreContainerImageResponse restoreContainerImage(RestoreContainerImageRequest request) {
        LOG.trace("Called restoreContainerImage");
        RestoreContainerImageRequest interceptedRequest = RestoreContainerImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreContainerImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreContainerImageResponse> transformer = RestoreContainerImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestoreContainerImageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestoreContainerImageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestoreContainerImageDetails(), (BmcRequest)retriedRequest);
                return (RestoreContainerImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateContainerConfigurationResponse updateContainerConfiguration(UpdateContainerConfigurationRequest request) {
        LOG.trace("Called updateContainerConfiguration");
        UpdateContainerConfigurationRequest interceptedRequest = UpdateContainerConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateContainerConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateContainerConfigurationResponse> transformer = UpdateContainerConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateContainerConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateContainerConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateContainerConfigurationDetails(), (BmcRequest)retriedRequest);
                return (UpdateContainerConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateContainerRepositoryResponse updateContainerRepository(UpdateContainerRepositoryRequest request) {
        LOG.trace("Called updateContainerRepository");
        UpdateContainerRepositoryRequest interceptedRequest = UpdateContainerRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateContainerRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateContainerRepositoryResponse> transformer = UpdateContainerRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateContainerRepositoryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateContainerRepositoryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateContainerRepositoryDetails(), (BmcRequest)retriedRequest);
                return (UpdateContainerRepositoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ArtifactsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ArtifactsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ArtifactsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ArtifactsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ArtifactsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

