/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.artifacts.Artifacts;
import com.oracle.bmc.artifacts.model.ContainerImage;
import com.oracle.bmc.artifacts.model.ContainerRepository;
import com.oracle.bmc.artifacts.requests.GetContainerImageRequest;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.responses.GetContainerImageResponse;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class ArtifactsWaiters {
    private final ExecutorService executorService;
    private final Artifacts client;

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, ContainerImage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, ContainerImage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerImage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(BmcGenericWaiter waiter, GetContainerImageRequest request, ContainerImage.LifecycleState ... targetStates) {
        final HashSet<ContainerImage.LifecycleState> targetStatesSet = new HashSet<ContainerImage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetContainerImageRequest, GetContainerImageResponse>(){

            public GetContainerImageResponse apply(GetContainerImageRequest request) {
                return ArtifactsWaiters.this.client.getContainerImage(request);
            }
        }, (Predicate)new Predicate<GetContainerImageResponse>(){

            public boolean apply(GetContainerImageResponse response) {
                return targetStatesSet.contains((Object)response.getContainerImage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerImage.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, ContainerRepository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, ContainerRepository.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerRepository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(BmcGenericWaiter waiter, GetContainerRepositoryRequest request, ContainerRepository.LifecycleState ... targetStates) {
        final HashSet<ContainerRepository.LifecycleState> targetStatesSet = new HashSet<ContainerRepository.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetContainerRepositoryRequest, GetContainerRepositoryResponse>(){

            public GetContainerRepositoryResponse apply(GetContainerRepositoryRequest request) {
                return ArtifactsWaiters.this.client.getContainerRepository(request);
            }
        }, (Predicate)new Predicate<GetContainerRepositoryResponse>(){

            public boolean apply(GetContainerRepositoryResponse response) {
                return targetStatesSet.contains((Object)response.getContainerRepository().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerRepository.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public ArtifactsWaiters(ExecutorService executorService, Artifacts client) {
        this.executorService = executorService;
        this.client = client;
    }
}

