/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.artifacts.model.ContainerImageCollection;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainerImagesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListContainerImagesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListContainerImagesRequest interceptRequest(ListContainerImagesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListContainerImagesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("container").path("images");
        if (request.getCompartmentIdInSubtree() != null) {
            target = target.queryParam("compartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentIdInSubtree())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getImageId() != null) {
            target = target.queryParam("imageId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getImageId())});
        }
        if (request.getIsVersioned() != null) {
            target = target.queryParam("isVersioned", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsVersioned())});
        }
        if (request.getRepositoryId() != null) {
            target = target.queryParam("repositoryId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRepositoryId())});
        }
        if (request.getRepositoryName() != null) {
            target = target.queryParam("repositoryName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRepositoryName())});
        }
        if (request.getVersion() != null) {
            target = target.queryParam("version", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getVersion())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListContainerImagesResponse> fromResponse() {
        Function<Response, ListContainerImagesResponse> transformer = new Function<Response, ListContainerImagesResponse>(){

            public ListContainerImagesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.artifacts.responses.ListContainerImagesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ContainerImageCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListContainerImagesResponse.Builder builder = ListContainerImagesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.containerImageCollection((ContainerImageCollection)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListContainerImagesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

