/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.blockchain.model.ScaledBlockchainPlatformPreview;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewScaleBlockchainPlatformConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewScaleBlockchainPlatformConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PreviewScaleBlockchainPlatformRequest interceptRequest(PreviewScaleBlockchainPlatformRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PreviewScaleBlockchainPlatformRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getScaleBlockchainPlatformDetails(), (String)"scaleBlockchainPlatformDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20191010").path("blockchainPlatforms").path(HttpUtils.encodePathSegment((String)request.getBlockchainPlatformId())).path("actions").path("scale").path("preview");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, PreviewScaleBlockchainPlatformResponse> fromResponse() {
        Function<Response, PreviewScaleBlockchainPlatformResponse> transformer = new Function<Response, PreviewScaleBlockchainPlatformResponse>(){

            public PreviewScaleBlockchainPlatformResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ScaledBlockchainPlatformPreview.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PreviewScaleBlockchainPlatformResponse.Builder builder = PreviewScaleBlockchainPlatformResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.scaledBlockchainPlatformPreview((ScaledBlockchainPlatformPreview)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                PreviewScaleBlockchainPlatformResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

