/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.CreatePeerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreatePeerRequest
extends BmcRequest<CreatePeerDetails> {
    private String blockchainPlatformId;
    private CreatePeerDetails createPeerDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreatePeerDetails getBody$() {
        return this.createPeerDetails;
    }

    @ConstructorProperties(value={"blockchainPlatformId", "createPeerDetails", "opcRequestId", "opcRetryToken"})
    CreatePeerRequest(String blockchainPlatformId, CreatePeerDetails createPeerDetails, String opcRequestId, String opcRetryToken) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.createPeerDetails = createPeerDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public CreatePeerDetails getCreatePeerDetails() {
        return this.createPeerDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePeerRequest, CreatePeerDetails> {
        private String blockchainPlatformId;
        private CreatePeerDetails createPeerDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePeerRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.createPeerDetails(o.getCreatePeerDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePeerRequest build() {
            CreatePeerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePeerDetails body) {
            this.createPeerDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder createPeerDetails(CreatePeerDetails createPeerDetails) {
            this.createPeerDetails = createPeerDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreatePeerRequest buildWithoutInvocationCallback() {
            return new CreatePeerRequest(this.blockchainPlatformId, this.createPeerDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreatePeerRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", createPeerDetails=" + this.createPeerDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

