/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBlockchainPlatformRequest
extends BmcRequest<Void> {
    private String blockchainPlatformId;
    private String opcRequestId;

    @ConstructorProperties(value={"blockchainPlatformId", "opcRequestId"})
    GetBlockchainPlatformRequest(String blockchainPlatformId, String opcRequestId) {
        this.blockchainPlatformId = blockchainPlatformId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBlockchainPlatformRequest, Void> {
        private String blockchainPlatformId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBlockchainPlatformRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBlockchainPlatformRequest build() {
            GetBlockchainPlatformRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBlockchainPlatformRequest buildWithoutInvocationCallback() {
            return new GetBlockchainPlatformRequest(this.blockchainPlatformId, this.opcRequestId);
        }

        public String toString() {
            return "GetBlockchainPlatformRequest.Builder(blockchainPlatformId=" + this.blockchainPlatformId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

