/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.budget.Budget;
import com.oracle.bmc.budget.BudgetPaginators;
import com.oracle.bmc.budget.BudgetWaiters;
import com.oracle.bmc.budget.internal.http.CreateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.CreateBudgetConverter;
import com.oracle.bmc.budget.internal.http.DeleteAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.DeleteBudgetConverter;
import com.oracle.bmc.budget.internal.http.GetAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.GetBudgetConverter;
import com.oracle.bmc.budget.internal.http.ListAlertRulesConverter;
import com.oracle.bmc.budget.internal.http.ListBudgetsConverter;
import com.oracle.bmc.budget.internal.http.UpdateAlertRuleConverter;
import com.oracle.bmc.budget.internal.http.UpdateBudgetConverter;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetClient
implements Budget {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BUDGET").serviceEndpointPrefix("").serviceEndpointTemplate("https://usage.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final BudgetWaiters waiters;
    private final BudgetPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BudgetClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected BudgetClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Budget-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BudgetWaiters(executorService, this);
        this.paginators = new BudgetPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CreateAlertRuleResponse createAlertRule(CreateAlertRuleRequest request) {
        LOG.trace("Called createAlertRule");
        CreateAlertRuleRequest interceptedRequest = CreateAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAlertRuleResponse> transformer = CreateAlertRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAlertRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAlertRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAlertRuleDetails(), (BmcRequest)retriedRequest);
                return (CreateAlertRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBudgetResponse createBudget(CreateBudgetRequest request) {
        LOG.trace("Called createBudget");
        CreateBudgetRequest interceptedRequest = CreateBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBudgetResponse> transformer = CreateBudgetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBudgetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBudgetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBudgetDetails(), (BmcRequest)retriedRequest);
                return (CreateBudgetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAlertRuleResponse deleteAlertRule(DeleteAlertRuleRequest request) {
        LOG.trace("Called deleteAlertRule");
        DeleteAlertRuleRequest interceptedRequest = DeleteAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAlertRuleResponse> transformer = DeleteAlertRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAlertRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAlertRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAlertRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBudgetResponse deleteBudget(DeleteBudgetRequest request) {
        LOG.trace("Called deleteBudget");
        DeleteBudgetRequest interceptedRequest = DeleteBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBudgetResponse> transformer = DeleteBudgetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBudgetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBudgetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBudgetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAlertRuleResponse getAlertRule(GetAlertRuleRequest request) {
        LOG.trace("Called getAlertRule");
        GetAlertRuleRequest interceptedRequest = GetAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlertRuleResponse> transformer = GetAlertRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAlertRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAlertRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAlertRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBudgetResponse getBudget(GetBudgetRequest request) {
        LOG.trace("Called getBudget");
        GetBudgetRequest interceptedRequest = GetBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBudgetResponse> transformer = GetBudgetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBudgetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBudgetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBudgetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAlertRulesResponse listAlertRules(ListAlertRulesRequest request) {
        LOG.trace("Called listAlertRules");
        ListAlertRulesRequest interceptedRequest = ListAlertRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlertRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlertRulesResponse> transformer = ListAlertRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAlertRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAlertRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAlertRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBudgetsResponse listBudgets(ListBudgetsRequest request) {
        LOG.trace("Called listBudgets");
        ListBudgetsRequest interceptedRequest = ListBudgetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBudgetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBudgetsResponse> transformer = ListBudgetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBudgetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBudgetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBudgetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAlertRuleResponse updateAlertRule(UpdateAlertRuleRequest request) {
        LOG.trace("Called updateAlertRule");
        UpdateAlertRuleRequest interceptedRequest = UpdateAlertRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAlertRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAlertRuleResponse> transformer = UpdateAlertRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAlertRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAlertRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAlertRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateAlertRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBudgetResponse updateBudget(UpdateBudgetRequest request) {
        LOG.trace("Called updateBudget");
        UpdateBudgetRequest interceptedRequest = UpdateBudgetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBudgetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBudgetResponse> transformer = UpdateBudgetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateBudgetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBudgetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBudgetDetails(), (BmcRequest)retriedRequest);
                return (UpdateBudgetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BudgetWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BudgetPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BudgetClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BudgetClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new BudgetClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

