/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.cloudguard.CloudGuard;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleState;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetManagedListRequest;
import com.oracle.bmc.cloudguard.requests.GetProblemRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetManagedListResponse;
import com.oracle.bmc.cloudguard.responses.GetProblemResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class CloudGuardWaiters {
    private final ExecutorService executorService;
    private final CloudGuard client;

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetector(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(BmcGenericWaiter waiter, GetDetectorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDetectorRequest, GetDetectorResponse>(){

            public GetDetectorResponse apply(GetDetectorRequest request) {
                return CloudGuardWaiters.this.client.getDetector(request);
            }
        }, (Predicate)new Predicate<GetDetectorResponse>(){

            public boolean apply(GetDetectorResponse response) {
                return targetStatesSet.contains((Object)response.getDetector().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(BmcGenericWaiter waiter, GetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDetectorRecipeRequest, GetDetectorRecipeResponse>(){

            public GetDetectorRecipeResponse apply(GetDetectorRecipeRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRecipe(request);
            }
        }, (Predicate)new Predicate<GetDetectorRecipeResponse>(){

            public boolean apply(GetDetectorRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(BmcGenericWaiter waiter, GetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse>(){

            public GetDetectorRecipeDetectorRuleResponse apply(GetDetectorRecipeDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRecipeDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetDetectorRecipeDetectorRuleResponse>(){

            public boolean apply(GetDetectorRecipeDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRecipeDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(BmcGenericWaiter waiter, GetDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDetectorRuleRequest, GetDetectorRuleResponse>(){

            public GetDetectorRuleResponse apply(GetDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetDetectorRuleResponse>(){

            public boolean apply(GetDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(BmcGenericWaiter waiter, GetManagedListRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetManagedListRequest, GetManagedListResponse>(){

            public GetManagedListResponse apply(GetManagedListRequest request) {
                return CloudGuardWaiters.this.client.getManagedList(request);
            }
        }, (Predicate)new Predicate<GetManagedListResponse>(){

            public boolean apply(GetManagedListResponse response) {
                return targetStatesSet.contains((Object)response.getManagedList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, ProblemLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProblem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, ProblemLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProblem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ProblemLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProblem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProblemRequest, GetProblemResponse> forProblem(BmcGenericWaiter waiter, GetProblemRequest request, ProblemLifecycleState ... targetStates) {
        final HashSet<ProblemLifecycleState> targetStatesSet = new HashSet<ProblemLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetProblemRequest, GetProblemResponse>(){

            public GetProblemResponse apply(GetProblemRequest request) {
                return CloudGuardWaiters.this.client.getProblem(request);
            }
        }, (Predicate)new Predicate<GetProblemResponse>(){

            public boolean apply(GetProblemResponse response) {
                return targetStatesSet.contains((Object)response.getProblem().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(BmcGenericWaiter waiter, GetResponderRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetResponderRecipeRequest, GetResponderRecipeResponse>(){

            public GetResponderRecipeResponse apply(GetResponderRecipeRequest request) {
                return CloudGuardWaiters.this.client.getResponderRecipe(request);
            }
        }, (Predicate)new Predicate<GetResponderRecipeResponse>(){

            public boolean apply(GetResponderRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(BmcGenericWaiter waiter, GetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse>(){

            public GetResponderRecipeResponderRuleResponse apply(GetResponderRecipeResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getResponderRecipeResponderRule(request);
            }
        }, (Predicate)new Predicate<GetResponderRecipeResponderRuleResponse>(){

            public boolean apply(GetResponderRecipeResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRecipeResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(BmcGenericWaiter waiter, GetResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetResponderRuleRequest, GetResponderRuleResponse>(){

            public GetResponderRuleResponse apply(GetResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getResponderRule(request);
            }
        }, (Predicate)new Predicate<GetResponderRuleResponse>(){

            public boolean apply(GetResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTarget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetRequest, GetTargetResponse> forTarget(BmcGenericWaiter waiter, GetTargetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTargetRequest, GetTargetResponse>(){

            public GetTargetResponse apply(GetTargetRequest request) {
                return CloudGuardWaiters.this.client.getTarget(request);
            }
        }, (Predicate)new Predicate<GetTargetResponse>(){

            public boolean apply(GetTargetResponse response) {
                return targetStatesSet.contains((Object)response.getTarget().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(BmcGenericWaiter waiter, GetTargetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse>(){

            public GetTargetDetectorRecipeResponse apply(GetTargetDetectorRecipeRequest request) {
                return CloudGuardWaiters.this.client.getTargetDetectorRecipe(request);
            }
        }, (Predicate)new Predicate<GetTargetDetectorRecipeResponse>(){

            public boolean apply(GetTargetDetectorRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getTargetDetectorRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(BmcGenericWaiter waiter, GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse>(){

            public GetTargetDetectorRecipeDetectorRuleResponse apply(GetTargetDetectorRecipeDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getTargetDetectorRecipeDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetTargetDetectorRecipeDetectorRuleResponse>(){

            public boolean apply(GetTargetDetectorRecipeDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getTargetDetectorRecipeDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(BmcGenericWaiter waiter, GetTargetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse>(){

            public GetTargetResponderRecipeResponderRuleResponse apply(GetTargetResponderRecipeResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getTargetResponderRecipeResponderRule(request);
            }
        }, (Predicate)new Predicate<GetTargetResponderRecipeResponderRuleResponse>(){

            public boolean apply(GetTargetResponderRecipeResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getTargetResponderRecipeResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public CloudGuardWaiters(ExecutorService executorService, CloudGuard client) {
        this.executorService = executorService;
        this.client = client;
    }
}

