/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipeDetectorRule;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTargetDetectorRecipeDetectorRuleConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTargetDetectorRecipeDetectorRuleConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTargetDetectorRecipeDetectorRuleRequest interceptRequest(GetTargetDetectorRecipeDetectorRuleRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTargetDetectorRecipeDetectorRuleRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("targets").path(HttpUtils.encodePathSegment((String)request.getTargetId())).path("targetDetectorRecipes").path(HttpUtils.encodePathSegment((String)request.getTargetDetectorRecipeId())).path("detectorRules").path(HttpUtils.encodePathSegment((String)request.getDetectorRuleId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetTargetDetectorRecipeDetectorRuleResponse> fromResponse() {
        Function<Response, GetTargetDetectorRecipeDetectorRuleResponse> transformer = new Function<Response, GetTargetDetectorRecipeDetectorRuleResponse>(){

            public GetTargetDetectorRecipeDetectorRuleResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TargetDetectorRecipeDetectorRule.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetTargetDetectorRecipeDetectorRuleResponse.Builder builder = GetTargetDetectorRecipeDetectorRuleResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.targetDetectorRecipeDetectorRule((TargetDetectorRecipeDetectorRule)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetTargetDetectorRecipeDetectorRuleResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

