/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.ProblemCollection;
import com.oracle.bmc.cloudguard.requests.ListProblemsRequest;
import com.oracle.bmc.cloudguard.responses.ListProblemsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProblemsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListProblemsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListProblemsRequest interceptRequest(ListProblemsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListProblemsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("problems");
        if (request.getTimeLastDetectedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeLastDetectedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeLastDetectedGreaterThanOrEqualTo())});
        }
        if (request.getTimeLastDetectedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeLastDetectedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeLastDetectedLessThanOrEqualTo())});
        }
        if (request.getTimeFirstDetectedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeFirstDetectedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeFirstDetectedGreaterThanOrEqualTo())});
        }
        if (request.getTimeFirstDetectedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeFirstDetectedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeFirstDetectedLessThanOrEqualTo())});
        }
        if (request.getLifecycleDetail() != null) {
            target = target.queryParam("lifecycleDetail", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleDetail().getValue())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getRegion() != null) {
            target = target.queryParam("region", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRegion())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getRiskLevel() != null) {
            target = target.queryParam("riskLevel", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRiskLevel())});
        }
        if (request.getResourceType() != null) {
            target = target.queryParam("resourceType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResourceType())});
        }
        if (request.getCity() != null) {
            target = target.queryParam("city", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCity())});
        }
        if (request.getState() != null) {
            target = target.queryParam("state", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getState())});
        }
        if (request.getCountry() != null) {
            target = target.queryParam("country", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCountry())});
        }
        if (request.getLabel() != null) {
            target = target.queryParam("label", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLabel())});
        }
        if (request.getDetectorRuleIdList() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"detectorRuleIdList", request.getDetectorRuleIdList(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getDetectorType() != null) {
            target = target.queryParam("detectorType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDetectorType().getValue())});
        }
        if (request.getTargetId() != null) {
            target = target.queryParam("targetId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTargetId())});
        }
        if (request.getCompartmentIdInSubtree() != null) {
            target = target.queryParam("compartmentIdInSubtree", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentIdInSubtree())});
        }
        if (request.getAccessLevel() != null) {
            target = target.queryParam("accessLevel", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAccessLevel().getValue())});
        }
        if (request.getResourceId() != null) {
            target = target.queryParam("resourceId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResourceId())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListProblemsResponse> fromResponse() {
        Function<Response, ListProblemsResponse> transformer = new Function<Response, ListProblemsResponse>(){

            public ListProblemsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.ListProblemsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ProblemCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListProblemsResponse.Builder builder = ListProblemsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.problemCollection((ProblemCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListProblemsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

