/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cloudguard.model.SecurityScoreTrendAggregationCollection;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendSecurityScoresRequest;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendSecurityScoresResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummarizedTrendSecurityScoresConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSummarizedTrendSecurityScoresConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RequestSummarizedTrendSecurityScoresRequest interceptRequest(RequestSummarizedTrendSecurityScoresRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RequestSummarizedTrendSecurityScoresRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200131").path("problems").path("actions").path("summarizeSecurityScoreTrend");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getTimeScoreComputedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeScoreComputedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeScoreComputedGreaterThanOrEqualTo())});
        }
        if (request.getTimeScoreComputedLessThanOrEqualTo() != null) {
            target = target.queryParam("timeScoreComputedLessThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeScoreComputedLessThanOrEqualTo())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RequestSummarizedTrendSecurityScoresResponse> fromResponse() {
        Function<Response, RequestSummarizedTrendSecurityScoresResponse> transformer = new Function<Response, RequestSummarizedTrendSecurityScoresResponse>(){

            public RequestSummarizedTrendSecurityScoresResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendSecurityScoresResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SecurityScoreTrendAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RequestSummarizedTrendSecurityScoresResponse.Builder builder = RequestSummarizedTrendSecurityScoresResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.securityScoreTrendAggregationCollection((SecurityScoreTrendAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                RequestSummarizedTrendSecurityScoresResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

