/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OperatorType {
    In("IN"),
    NotIn("NOT_IN"),
    Equals("EQUALS"),
    NotEquals("NOT_EQUALS");

    private final String value;
    private static Map<String, OperatorType> map;

    private OperatorType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static OperatorType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid OperatorType: " + key);
    }

    static {
        map = new HashMap<String, OperatorType>();
        for (OperatorType v : OperatorType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

