/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteTargetResponderRecipeRequest
extends BmcRequest<Void> {
    private String targetId;
    private String targetResponderRecipeId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"targetId", "targetResponderRecipeId", "ifMatch", "opcRequestId"})
    DeleteTargetResponderRecipeRequest(String targetId, String targetResponderRecipeId, String ifMatch, String opcRequestId) {
        this.targetId = targetId;
        this.targetResponderRecipeId = targetResponderRecipeId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetResponderRecipeId() {
        return this.targetResponderRecipeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTargetResponderRecipeRequest, Void> {
        private String targetId;
        private String targetResponderRecipeId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTargetResponderRecipeRequest o) {
            this.targetId(o.getTargetId());
            this.targetResponderRecipeId(o.getTargetResponderRecipeId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTargetResponderRecipeRequest build() {
            DeleteTargetResponderRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetResponderRecipeId(String targetResponderRecipeId) {
            this.targetResponderRecipeId = targetResponderRecipeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteTargetResponderRecipeRequest buildWithoutInvocationCallback() {
            return new DeleteTargetResponderRecipeRequest(this.targetId, this.targetResponderRecipeId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteTargetResponderRecipeRequest.Builder(targetId=" + this.targetId + ", targetResponderRecipeId=" + this.targetResponderRecipeId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

