/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetProblemRequest
extends BmcRequest<Void> {
    private String problemId;
    private String opcRequestId;

    @ConstructorProperties(value={"problemId", "opcRequestId"})
    GetProblemRequest(String problemId, String opcRequestId) {
        this.problemId = problemId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProblemId() {
        return this.problemId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProblemRequest, Void> {
        private String problemId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProblemRequest o) {
            this.problemId(o.getProblemId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProblemRequest build() {
            GetProblemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetProblemRequest buildWithoutInvocationCallback() {
            return new GetProblemRequest(this.problemId, this.opcRequestId);
        }

        public String toString() {
            return "GetProblemRequest.Builder(problemId=" + this.problemId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

