/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResponderRecipeRequest
extends BmcRequest<Void> {
    private String responderRecipeId;
    private String opcRequestId;

    @ConstructorProperties(value={"responderRecipeId", "opcRequestId"})
    GetResponderRecipeRequest(String responderRecipeId, String opcRequestId) {
        this.responderRecipeId = responderRecipeId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResponderRecipeId() {
        return this.responderRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResponderRecipeRequest, Void> {
        private String responderRecipeId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResponderRecipeRequest o) {
            this.responderRecipeId(o.getResponderRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResponderRecipeRequest build() {
            GetResponderRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder responderRecipeId(String responderRecipeId) {
            this.responderRecipeId = responderRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetResponderRecipeRequest buildWithoutInvocationCallback() {
            return new GetResponderRecipeRequest(this.responderRecipeId, this.opcRequestId);
        }

        public String toString() {
            return "GetResponderRecipeRequest.Builder(responderRecipeId=" + this.responderRecipeId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

