/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTargetDetectorRecipeRequest
extends BmcRequest<Void> {
    private String targetId;
    private String targetDetectorRecipeId;
    private String opcRequestId;

    @ConstructorProperties(value={"targetId", "targetDetectorRecipeId", "opcRequestId"})
    GetTargetDetectorRecipeRequest(String targetId, String targetDetectorRecipeId, String opcRequestId) {
        this.targetId = targetId;
        this.targetDetectorRecipeId = targetDetectorRecipeId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetDetectorRecipeId() {
        return this.targetDetectorRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTargetDetectorRecipeRequest, Void> {
        private String targetId;
        private String targetDetectorRecipeId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTargetDetectorRecipeRequest o) {
            this.targetId(o.getTargetId());
            this.targetDetectorRecipeId(o.getTargetDetectorRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTargetDetectorRecipeRequest build() {
            GetTargetDetectorRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetDetectorRecipeId(String targetDetectorRecipeId) {
            this.targetDetectorRecipeId = targetDetectorRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTargetDetectorRecipeRequest buildWithoutInvocationCallback() {
            return new GetTargetDetectorRecipeRequest(this.targetId, this.targetDetectorRecipeId, this.opcRequestId);
        }

        public String toString() {
            return "GetTargetDetectorRecipeRequest.Builder(targetId=" + this.targetId + ", targetDetectorRecipeId=" + this.targetDetectorRecipeId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

