/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleDetail;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleState;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListProblemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeLastDetectedGreaterThanOrEqualTo;
    private Date timeLastDetectedLessThanOrEqualTo;
    private Date timeFirstDetectedGreaterThanOrEqualTo;
    private Date timeFirstDetectedLessThanOrEqualTo;
    private ProblemLifecycleDetail lifecycleDetail;
    private ProblemLifecycleState lifecycleState;
    private String region;
    private String riskLevel;
    private String resourceType;
    private String city;
    private String state;
    private String country;
    private String label;
    private List<String> detectorRuleIdList;
    private DetectorEnum detectorType;
    private String targetId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String resourceId;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "timeLastDetectedGreaterThanOrEqualTo", "timeLastDetectedLessThanOrEqualTo", "timeFirstDetectedGreaterThanOrEqualTo", "timeFirstDetectedLessThanOrEqualTo", "lifecycleDetail", "lifecycleState", "region", "riskLevel", "resourceType", "city", "state", "country", "label", "detectorRuleIdList", "detectorType", "targetId", "compartmentIdInSubtree", "accessLevel", "resourceId", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListProblemsRequest(String compartmentId, Date timeLastDetectedGreaterThanOrEqualTo, Date timeLastDetectedLessThanOrEqualTo, Date timeFirstDetectedGreaterThanOrEqualTo, Date timeFirstDetectedLessThanOrEqualTo, ProblemLifecycleDetail lifecycleDetail, ProblemLifecycleState lifecycleState, String region, String riskLevel, String resourceType, String city, String state, String country, String label, List<String> detectorRuleIdList, DetectorEnum detectorType, String targetId, Boolean compartmentIdInSubtree, AccessLevel accessLevel, String resourceId, Integer limit, String page, SortOrders sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
        this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
        this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
        this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
        this.lifecycleDetail = lifecycleDetail;
        this.lifecycleState = lifecycleState;
        this.region = region;
        this.riskLevel = riskLevel;
        this.resourceType = resourceType;
        this.city = city;
        this.state = state;
        this.country = country;
        this.label = label;
        this.detectorRuleIdList = detectorRuleIdList;
        this.detectorType = detectorType;
        this.targetId = targetId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.resourceId = resourceId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeLastDetectedGreaterThanOrEqualTo() {
        return this.timeLastDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeLastDetectedLessThanOrEqualTo() {
        return this.timeLastDetectedLessThanOrEqualTo;
    }

    public Date getTimeFirstDetectedGreaterThanOrEqualTo() {
        return this.timeFirstDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeFirstDetectedLessThanOrEqualTo() {
        return this.timeFirstDetectedLessThanOrEqualTo;
    }

    public ProblemLifecycleDetail getLifecycleDetail() {
        return this.lifecycleDetail;
    }

    public ProblemLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRiskLevel() {
        return this.riskLevel;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getDetectorRuleIdList() {
        return this.detectorRuleIdList;
    }

    public DetectorEnum getDetectorType() {
        return this.detectorType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProblemsRequest, Void> {
        private String compartmentId;
        private Date timeLastDetectedGreaterThanOrEqualTo;
        private Date timeLastDetectedLessThanOrEqualTo;
        private Date timeFirstDetectedGreaterThanOrEqualTo;
        private Date timeFirstDetectedLessThanOrEqualTo;
        private ProblemLifecycleDetail lifecycleDetail;
        private ProblemLifecycleState lifecycleState;
        private String region;
        private String riskLevel;
        private String resourceType;
        private String city;
        private String state;
        private String country;
        private String label;
        private List<String> detectorRuleIdList;
        private DetectorEnum detectorType;
        private String targetId;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private String resourceId;
        private Integer limit;
        private String page;
        private SortOrders sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProblemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeLastDetectedGreaterThanOrEqualTo(o.getTimeLastDetectedGreaterThanOrEqualTo());
            this.timeLastDetectedLessThanOrEqualTo(o.getTimeLastDetectedLessThanOrEqualTo());
            this.timeFirstDetectedGreaterThanOrEqualTo(o.getTimeFirstDetectedGreaterThanOrEqualTo());
            this.timeFirstDetectedLessThanOrEqualTo(o.getTimeFirstDetectedLessThanOrEqualTo());
            this.lifecycleDetail(o.getLifecycleDetail());
            this.lifecycleState(o.getLifecycleState());
            this.region(o.getRegion());
            this.riskLevel(o.getRiskLevel());
            this.resourceType(o.getResourceType());
            this.city(o.getCity());
            this.state(o.getState());
            this.country(o.getCountry());
            this.label(o.getLabel());
            this.detectorRuleIdList(o.getDetectorRuleIdList());
            this.detectorType(o.getDetectorType());
            this.targetId(o.getTargetId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.resourceId(o.getResourceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProblemsRequest build() {
            ListProblemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeLastDetectedGreaterThanOrEqualTo(Date timeLastDetectedGreaterThanOrEqualTo) {
            this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLastDetectedLessThanOrEqualTo(Date timeLastDetectedLessThanOrEqualTo) {
            this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedGreaterThanOrEqualTo(Date timeFirstDetectedGreaterThanOrEqualTo) {
            this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedLessThanOrEqualTo(Date timeFirstDetectedLessThanOrEqualTo) {
            this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder lifecycleDetail(ProblemLifecycleDetail lifecycleDetail) {
            this.lifecycleDetail = lifecycleDetail;
            return this;
        }

        public Builder lifecycleState(ProblemLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder detectorRuleIdList(List<String> detectorRuleIdList) {
            this.detectorRuleIdList = detectorRuleIdList;
            return this;
        }

        public Builder detectorType(DetectorEnum detectorType) {
            this.detectorType = detectorType;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListProblemsRequest buildWithoutInvocationCallback() {
            return new ListProblemsRequest(this.compartmentId, this.timeLastDetectedGreaterThanOrEqualTo, this.timeLastDetectedLessThanOrEqualTo, this.timeFirstDetectedGreaterThanOrEqualTo, this.timeFirstDetectedLessThanOrEqualTo, this.lifecycleDetail, this.lifecycleState, this.region, this.riskLevel, this.resourceType, this.city, this.state, this.country, this.label, this.detectorRuleIdList, this.detectorType, this.targetId, this.compartmentIdInSubtree, this.accessLevel, this.resourceId, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListProblemsRequest.Builder(compartmentId=" + this.compartmentId + ", timeLastDetectedGreaterThanOrEqualTo=" + this.timeLastDetectedGreaterThanOrEqualTo + ", timeLastDetectedLessThanOrEqualTo=" + this.timeLastDetectedLessThanOrEqualTo + ", timeFirstDetectedGreaterThanOrEqualTo=" + this.timeFirstDetectedGreaterThanOrEqualTo + ", timeFirstDetectedLessThanOrEqualTo=" + this.timeFirstDetectedLessThanOrEqualTo + ", lifecycleDetail=" + (Object)((Object)this.lifecycleDetail) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", region=" + this.region + ", riskLevel=" + this.riskLevel + ", resourceType=" + this.resourceType + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", label=" + this.label + ", detectorRuleIdList=" + this.detectorRuleIdList + ", detectorType=" + (Object)((Object)this.detectorType) + ", targetId=" + this.targetId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", resourceId=" + this.resourceId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        RiskLevel("riskLevel"),
        TimeLastDetected("timeLastDetected"),
        ResourceName("resourceName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

