/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class RequestSummarizedTrendProblemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeFirstDetectedGreaterThanOrEqualTo;
    private Date timeFirstDetectedLessThanOrEqualTo;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "timeFirstDetectedGreaterThanOrEqualTo", "timeFirstDetectedLessThanOrEqualTo", "compartmentIdInSubtree", "accessLevel", "limit", "page", "opcRequestId"})
    RequestSummarizedTrendProblemsRequest(String compartmentId, Date timeFirstDetectedGreaterThanOrEqualTo, Date timeFirstDetectedLessThanOrEqualTo, Boolean compartmentIdInSubtree, AccessLevel accessLevel, Integer limit, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
        this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
        this.accessLevel = accessLevel;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeFirstDetectedGreaterThanOrEqualTo() {
        return this.timeFirstDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeFirstDetectedLessThanOrEqualTo() {
        return this.timeFirstDetectedLessThanOrEqualTo;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedTrendProblemsRequest, Void> {
        private String compartmentId;
        private Date timeFirstDetectedGreaterThanOrEqualTo;
        private Date timeFirstDetectedLessThanOrEqualTo;
        private Boolean compartmentIdInSubtree;
        private AccessLevel accessLevel;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedTrendProblemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeFirstDetectedGreaterThanOrEqualTo(o.getTimeFirstDetectedGreaterThanOrEqualTo());
            this.timeFirstDetectedLessThanOrEqualTo(o.getTimeFirstDetectedLessThanOrEqualTo());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedTrendProblemsRequest build() {
            RequestSummarizedTrendProblemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeFirstDetectedGreaterThanOrEqualTo(Date timeFirstDetectedGreaterThanOrEqualTo) {
            this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedLessThanOrEqualTo(Date timeFirstDetectedLessThanOrEqualTo) {
            this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RequestSummarizedTrendProblemsRequest buildWithoutInvocationCallback() {
            return new RequestSummarizedTrendProblemsRequest(this.compartmentId, this.timeFirstDetectedGreaterThanOrEqualTo, this.timeFirstDetectedLessThanOrEqualTo, this.compartmentIdInSubtree, this.accessLevel, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "RequestSummarizedTrendProblemsRequest.Builder(compartmentId=" + this.compartmentId + ", timeFirstDetectedGreaterThanOrEqualTo=" + this.timeFirstDetectedGreaterThanOrEqualTo + ", timeFirstDetectedLessThanOrEqualTo=" + this.timeFirstDetectedLessThanOrEqualTo + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ", accessLevel=" + (Object)((Object)this.accessLevel) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum AccessLevel {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

