/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgentAsync;
import com.oracle.bmc.computeinstanceagent.internal.http.CancelInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.CreateInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.GetInstanceAgentCommandConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.GetInstanceAgentCommandExecutionConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.ListInstanceAgentCommandExecutionsConverter;
import com.oracle.bmc.computeinstanceagent.internal.http.ListInstanceAgentCommandsConverter;
import com.oracle.bmc.computeinstanceagent.requests.CancelInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.CreateInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandExecutionsRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandsRequest;
import com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandExecutionsResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeInstanceAgentAsyncClient
implements ComputeInstanceAgentAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeInstanceAgentAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEINSTANCEAGENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelInstanceAgentCommandResponse> cancelInstanceAgentCommand(CancelInstanceAgentCommandRequest request, AsyncHandler<CancelInstanceAgentCommandRequest, CancelInstanceAgentCommandResponse> handler) {
        LOG.trace("Called async cancelInstanceAgentCommand");
        CancelInstanceAgentCommandRequest interceptedRequest = CancelInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelInstanceAgentCommandResponse> transformer = CancelInstanceAgentCommandConverter.fromResponse();
        AsyncHandler<CancelInstanceAgentCommandRequest, CancelInstanceAgentCommandResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelInstanceAgentCommandRequest, CancelInstanceAgentCommandResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateInstanceAgentCommandResponse> createInstanceAgentCommand(CreateInstanceAgentCommandRequest request, AsyncHandler<CreateInstanceAgentCommandRequest, CreateInstanceAgentCommandResponse> handler) {
        LOG.trace("Called async createInstanceAgentCommand");
        CreateInstanceAgentCommandRequest interceptedRequest = CreateInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInstanceAgentCommandResponse> transformer = CreateInstanceAgentCommandConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateInstanceAgentCommandRequest, CreateInstanceAgentCommandResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateInstanceAgentCommandRequest, CreateInstanceAgentCommandResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetInstanceAgentCommandResponse> getInstanceAgentCommand(GetInstanceAgentCommandRequest request, AsyncHandler<GetInstanceAgentCommandRequest, GetInstanceAgentCommandResponse> handler) {
        LOG.trace("Called async getInstanceAgentCommand");
        GetInstanceAgentCommandRequest interceptedRequest = GetInstanceAgentCommandConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceAgentCommandConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceAgentCommandResponse> transformer = GetInstanceAgentCommandConverter.fromResponse();
        AsyncHandler<GetInstanceAgentCommandRequest, GetInstanceAgentCommandResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetInstanceAgentCommandRequest, GetInstanceAgentCommandResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetInstanceAgentCommandExecutionResponse> getInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request, AsyncHandler<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> handler) {
        LOG.trace("Called async getInstanceAgentCommandExecution");
        GetInstanceAgentCommandExecutionRequest interceptedRequest = GetInstanceAgentCommandExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceAgentCommandExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceAgentCommandExecutionResponse> transformer = GetInstanceAgentCommandExecutionConverter.fromResponse();
        AsyncHandler<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListInstanceAgentCommandExecutionsResponse> listInstanceAgentCommandExecutions(ListInstanceAgentCommandExecutionsRequest request, AsyncHandler<ListInstanceAgentCommandExecutionsRequest, ListInstanceAgentCommandExecutionsResponse> handler) {
        LOG.trace("Called async listInstanceAgentCommandExecutions");
        ListInstanceAgentCommandExecutionsRequest interceptedRequest = ListInstanceAgentCommandExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceAgentCommandExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceAgentCommandExecutionsResponse> transformer = ListInstanceAgentCommandExecutionsConverter.fromResponse();
        AsyncHandler<ListInstanceAgentCommandExecutionsRequest, ListInstanceAgentCommandExecutionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListInstanceAgentCommandExecutionsRequest, ListInstanceAgentCommandExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListInstanceAgentCommandsResponse> listInstanceAgentCommands(ListInstanceAgentCommandsRequest request, AsyncHandler<ListInstanceAgentCommandsRequest, ListInstanceAgentCommandsResponse> handler) {
        LOG.trace("Called async listInstanceAgentCommands");
        ListInstanceAgentCommandsRequest interceptedRequest = ListInstanceAgentCommandsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceAgentCommandsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceAgentCommandsResponse> transformer = ListInstanceAgentCommandsConverter.fromResponse();
        AsyncHandler<ListInstanceAgentCommandsRequest, ListInstanceAgentCommandsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListInstanceAgentCommandsRequest, ListInstanceAgentCommandsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeInstanceAgentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputeInstanceAgentAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ComputeInstanceAgentAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

