/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.computeinstanceagent.requests.CancelInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelInstanceAgentCommandConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CancelInstanceAgentCommandConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CancelInstanceAgentCommandRequest interceptRequest(CancelInstanceAgentCommandRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CancelInstanceAgentCommandRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getInstanceAgentCommandId(), (String)"instanceAgentCommandId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180530").path("instanceAgentCommands").path(HttpUtils.encodePathSegment((String)request.getInstanceAgentCommandId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, CancelInstanceAgentCommandResponse> fromResponse() {
        Function<Response, CancelInstanceAgentCommandResponse> transformer = new Function<Response, CancelInstanceAgentCommandResponse>(){

            public CancelInstanceAgentCommandResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CancelInstanceAgentCommandResponse.Builder builder = CancelInstanceAgentCommandResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CancelInstanceAgentCommandResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

