/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.requests.DownloadExadataInfrastructureConfigFileRequest;
import com.oracle.bmc.database.responses.DownloadExadataInfrastructureConfigFileResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadExadataInfrastructureConfigFileConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadExadataInfrastructureConfigFileConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DownloadExadataInfrastructureConfigFileRequest interceptRequest(DownloadExadataInfrastructureConfigFileRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DownloadExadataInfrastructureConfigFileRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExadataInfrastructureId(), (String)"exadataInfrastructureId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("exadataInfrastructures").path(HttpUtils.encodePathSegment((String)request.getExadataInfrastructureId())).path("actions").path("downloadConfigFile");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/octet-stream"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, DownloadExadataInfrastructureConfigFileResponse> fromResponse() {
        Function<Response, DownloadExadataInfrastructureConfigFileResponse> transformer = new Function<Response, DownloadExadataInfrastructureConfigFileResponse>(){

            public DownloadExadataInfrastructureConfigFileResponse apply(Response rawResponse) {
                Optional lastModifiedHeader;
                Optional contentLengthHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.DownloadExadataInfrastructureConfigFileResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DownloadExadataInfrastructureConfigFileResponse.Builder builder = DownloadExadataInfrastructureConfigFileResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                DownloadExadataInfrastructureConfigFileResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

