/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.ExternalContainerDatabase;
import com.oracle.bmc.database.requests.GetExternalContainerDatabaseRequest;
import com.oracle.bmc.database.responses.GetExternalContainerDatabaseResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExternalContainerDatabaseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetExternalContainerDatabaseConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetExternalContainerDatabaseRequest interceptRequest(GetExternalContainerDatabaseRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetExternalContainerDatabaseRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExternalContainerDatabaseId(), (String)"externalContainerDatabaseId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("externalcontainerdatabases").path(HttpUtils.encodePathSegment((String)request.getExternalContainerDatabaseId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetExternalContainerDatabaseResponse> fromResponse() {
        Function<Response, GetExternalContainerDatabaseResponse> transformer = new Function<Response, GetExternalContainerDatabaseResponse>(){

            public GetExternalContainerDatabaseResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetExternalContainerDatabaseResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExternalContainerDatabase.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetExternalContainerDatabaseResponse.Builder builder = GetExternalContainerDatabaseResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.externalContainerDatabase((ExternalContainerDatabase)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetExternalContainerDatabaseResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

