/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConsoleConnectionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleConnectionId;
    private String ifMatch;

    @ConstructorProperties(value={"dbNodeId", "consoleConnectionId", "ifMatch"})
    DeleteConsoleConnectionRequest(String dbNodeId, String consoleConnectionId, String ifMatch) {
        this.dbNodeId = dbNodeId;
        this.consoleConnectionId = consoleConnectionId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConsoleConnectionRequest, Void> {
        private String dbNodeId;
        private String consoleConnectionId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConsoleConnectionRequest build() {
            DeleteConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new DeleteConsoleConnectionRequest(this.dbNodeId, this.consoleConnectionId, this.ifMatch);
        }

        public String toString() {
            return "DeleteConsoleConnectionRequest.Builder(dbNodeId=" + this.dbNodeId + ", consoleConnectionId=" + this.consoleConnectionId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

