/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemPatchRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String patchId;

    @ConstructorProperties(value={"dbSystemId", "patchId"})
    GetDbSystemPatchRequest(String dbSystemId, String patchId) {
        this.dbSystemId = dbSystemId;
        this.patchId = patchId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemPatchRequest, Void> {
        private String dbSystemId;
        private String patchId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemPatchRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchId(o.getPatchId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemPatchRequest build() {
            GetDbSystemPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public GetDbSystemPatchRequest buildWithoutInvocationCallback() {
            return new GetDbSystemPatchRequest(this.dbSystemId, this.patchId);
        }

        public String toString() {
            return "GetDbSystemPatchRequest.Builder(dbSystemId=" + this.dbSystemId + ", patchId=" + this.patchId + ")";
        }
    }
}

