/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVmClusterPatchRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private String patchId;

    @ConstructorProperties(value={"vmClusterId", "patchId"})
    GetVmClusterPatchRequest(String vmClusterId, String patchId) {
        this.vmClusterId = vmClusterId;
        this.patchId = patchId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVmClusterPatchRequest, Void> {
        private String vmClusterId;
        private String patchId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVmClusterPatchRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.patchId(o.getPatchId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVmClusterPatchRequest build() {
            GetVmClusterPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public GetVmClusterPatchRequest buildWithoutInvocationCallback() {
            return new GetVmClusterPatchRequest(this.vmClusterId, this.patchId);
        }

        public String toString() {
            return "GetVmClusterPatchRequest.Builder(vmClusterId=" + this.vmClusterId + ", patchId=" + this.patchId + ")";
        }
    }
}

