/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class TerminateDbSystemRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String ifMatch;

    @ConstructorProperties(value={"dbSystemId", "ifMatch"})
    TerminateDbSystemRequest(String dbSystemId, String ifMatch) {
        this.dbSystemId = dbSystemId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<TerminateDbSystemRequest, Void> {
        private String dbSystemId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TerminateDbSystemRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TerminateDbSystemRequest build() {
            TerminateDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public TerminateDbSystemRequest buildWithoutInvocationCallback() {
            return new TerminateDbSystemRequest(this.dbSystemId, this.ifMatch);
        }

        public String toString() {
            return "TerminateDbSystemRequest.Builder(dbSystemId=" + this.dbSystemId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

