/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datacatalog.DataCatalogAsync;
import com.oracle.bmc.datacatalog.internal.http.AddDataSelectorPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.AssociateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.AttachCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.ChangeCatalogCompartmentConverter;
import com.oracle.bmc.datacatalog.internal.http.ChangeCatalogPrivateEndpointCompartmentConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobExecutionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.CreatePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateTermConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteJobConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.DeletePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteTermConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.DetachCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.DisassociateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.ExpandTreeForGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.ExportGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.GetAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.GetAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.GetConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.GetDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.GetDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.GetEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.GetFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobExecutionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobLogConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobMetricsConverter;
import com.oracle.bmc.datacatalog.internal.http.GetNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.GetPatternConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTermConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTypeConverter;
import com.oracle.bmc.datacatalog.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datacatalog.internal.http.ImportConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ImportGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAggregatedPhysicalEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAttributeTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAttributesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCatalogPrivateEndpointsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCatalogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListConnectionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCustomPropertiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDataAssetTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDataAssetsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDerivedLogicalEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListEntityTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListFolderTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListFoldersConverter;
import com.oracle.bmc.datacatalog.internal.http.ListGlossariesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobDefinitionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobExecutionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobLogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobMetricsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListNamespacesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListRulesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTermRelationshipsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTermsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTypesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datacatalog.internal.http.ObjectStatsConverter;
import com.oracle.bmc.datacatalog.internal.http.ParseConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ProcessRecommendationConverter;
import com.oracle.bmc.datacatalog.internal.http.RecommendationsConverter;
import com.oracle.bmc.datacatalog.internal.http.RemoveDataSelectorPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.SearchCriteriaConverter;
import com.oracle.bmc.datacatalog.internal.http.TestConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateJobConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdatePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateTermConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.UploadCredentialsConverter;
import com.oracle.bmc.datacatalog.internal.http.UsersConverter;
import com.oracle.bmc.datacatalog.internal.http.ValidateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ValidatePatternConverter;
import com.oracle.bmc.datacatalog.requests.AddDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.AssociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.AttachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogPrivateEndpointCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.CreateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.CreateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobRequest;
import com.oracle.bmc.datacatalog.requests.CreateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.CreatePatternRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogRequest;
import com.oracle.bmc.datacatalog.requests.DeleteConnectionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobRequest;
import com.oracle.bmc.datacatalog.requests.DeleteNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.DeletePatternRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRequest;
import com.oracle.bmc.datacatalog.requests.DetachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DisassociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.ExpandTreeForGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ExportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogRequest;
import com.oracle.bmc.datacatalog.requests.GetConnectionRequest;
import com.oracle.bmc.datacatalog.requests.GetCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.GetGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobLogRequest;
import com.oracle.bmc.datacatalog.requests.GetJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.GetJobRequest;
import com.oracle.bmc.datacatalog.requests.GetNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.GetPatternRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRequest;
import com.oracle.bmc.datacatalog.requests.GetTypeRequest;
import com.oracle.bmc.datacatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.datacatalog.requests.ImportConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ImportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ListAggregatedPhysicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributeTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributesRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogPrivateEndpointsRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogsRequest;
import com.oracle.bmc.datacatalog.requests.ListConnectionsRequest;
import com.oracle.bmc.datacatalog.requests.ListCustomPropertiesRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetsRequest;
import com.oracle.bmc.datacatalog.requests.ListDerivedLogicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntityTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFolderTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFoldersRequest;
import com.oracle.bmc.datacatalog.requests.ListGlossariesRequest;
import com.oracle.bmc.datacatalog.requests.ListJobDefinitionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobExecutionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobsRequest;
import com.oracle.bmc.datacatalog.requests.ListNamespacesRequest;
import com.oracle.bmc.datacatalog.requests.ListPatternsRequest;
import com.oracle.bmc.datacatalog.requests.ListRulesRequest;
import com.oracle.bmc.datacatalog.requests.ListTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermRelationshipsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermsRequest;
import com.oracle.bmc.datacatalog.requests.ListTypesRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datacatalog.requests.ObjectStatsRequest;
import com.oracle.bmc.datacatalog.requests.ParseConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ProcessRecommendationRequest;
import com.oracle.bmc.datacatalog.requests.RecommendationsRequest;
import com.oracle.bmc.datacatalog.requests.RemoveDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.SearchCriteriaRequest;
import com.oracle.bmc.datacatalog.requests.TestConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.UpdateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.UpdateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.UpdateEntityRequest;
import com.oracle.bmc.datacatalog.requests.UpdateFolderRequest;
import com.oracle.bmc.datacatalog.requests.UpdateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobRequest;
import com.oracle.bmc.datacatalog.requests.UpdateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.UpdatePatternRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRequest;
import com.oracle.bmc.datacatalog.requests.UploadCredentialsRequest;
import com.oracle.bmc.datacatalog.requests.UsersRequest;
import com.oracle.bmc.datacatalog.requests.ValidateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ValidatePatternRequest;
import com.oracle.bmc.datacatalog.responses.AddDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.AssociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.AttachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogPrivateEndpointCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.CreateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.CreateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobResponse;
import com.oracle.bmc.datacatalog.responses.CreateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.CreatePatternResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogResponse;
import com.oracle.bmc.datacatalog.responses.DeleteConnectionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobResponse;
import com.oracle.bmc.datacatalog.responses.DeleteNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.DeletePatternResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermResponse;
import com.oracle.bmc.datacatalog.responses.DetachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DisassociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.ExpandTreeForGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ExportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogResponse;
import com.oracle.bmc.datacatalog.responses.GetConnectionResponse;
import com.oracle.bmc.datacatalog.responses.GetCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.GetGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobLogResponse;
import com.oracle.bmc.datacatalog.responses.GetJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.GetJobResponse;
import com.oracle.bmc.datacatalog.responses.GetNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.GetPatternResponse;
import com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.GetTermResponse;
import com.oracle.bmc.datacatalog.responses.GetTypeResponse;
import com.oracle.bmc.datacatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.datacatalog.responses.ImportConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ImportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ListAggregatedPhysicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributeTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributesResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogPrivateEndpointsResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogsResponse;
import com.oracle.bmc.datacatalog.responses.ListConnectionsResponse;
import com.oracle.bmc.datacatalog.responses.ListCustomPropertiesResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetsResponse;
import com.oracle.bmc.datacatalog.responses.ListDerivedLogicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntityTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFolderTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFoldersResponse;
import com.oracle.bmc.datacatalog.responses.ListGlossariesResponse;
import com.oracle.bmc.datacatalog.responses.ListJobDefinitionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobExecutionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobsResponse;
import com.oracle.bmc.datacatalog.responses.ListNamespacesResponse;
import com.oracle.bmc.datacatalog.responses.ListPatternsResponse;
import com.oracle.bmc.datacatalog.responses.ListRulesResponse;
import com.oracle.bmc.datacatalog.responses.ListTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermRelationshipsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermsResponse;
import com.oracle.bmc.datacatalog.responses.ListTypesResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datacatalog.responses.ObjectStatsResponse;
import com.oracle.bmc.datacatalog.responses.ParseConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ProcessRecommendationResponse;
import com.oracle.bmc.datacatalog.responses.RecommendationsResponse;
import com.oracle.bmc.datacatalog.responses.RemoveDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.SearchCriteriaResponse;
import com.oracle.bmc.datacatalog.responses.TestConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.UpdateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.UpdateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.UpdateEntityResponse;
import com.oracle.bmc.datacatalog.responses.UpdateFolderResponse;
import com.oracle.bmc.datacatalog.responses.UpdateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobResponse;
import com.oracle.bmc.datacatalog.responses.UpdateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.UpdatePatternResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermResponse;
import com.oracle.bmc.datacatalog.responses.UploadCredentialsResponse;
import com.oracle.bmc.datacatalog.responses.UsersResponse;
import com.oracle.bmc.datacatalog.responses.ValidateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ValidatePatternResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogAsyncClient
implements DataCatalogAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATACATALOG").serviceEndpointPrefix("").serviceEndpointTemplate("https://datacatalog.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DataCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataCatalogAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataCatalogAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddDataSelectorPatternsResponse> addDataSelectorPatterns(AddDataSelectorPatternsRequest request, AsyncHandler<AddDataSelectorPatternsRequest, AddDataSelectorPatternsResponse> handler) {
        LOG.trace("Called async addDataSelectorPatterns");
        AddDataSelectorPatternsRequest interceptedRequest = AddDataSelectorPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddDataSelectorPatternsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AddDataSelectorPatternsResponse> transformer = AddDataSelectorPatternsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddDataSelectorPatternsRequest, AddDataSelectorPatternsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddDataSelectorPatternsRequest, AddDataSelectorPatternsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AssociateCustomPropertyResponse> associateCustomProperty(AssociateCustomPropertyRequest request, AsyncHandler<AssociateCustomPropertyRequest, AssociateCustomPropertyResponse> handler) {
        LOG.trace("Called async associateCustomProperty");
        AssociateCustomPropertyRequest interceptedRequest = AssociateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AssociateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AssociateCustomPropertyResponse> transformer = AssociateCustomPropertyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AssociateCustomPropertyRequest, AssociateCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AssociateCustomPropertyRequest, AssociateCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AttachCatalogPrivateEndpointResponse> attachCatalogPrivateEndpoint(AttachCatalogPrivateEndpointRequest request, AsyncHandler<AttachCatalogPrivateEndpointRequest, AttachCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async attachCatalogPrivateEndpoint");
        AttachCatalogPrivateEndpointRequest interceptedRequest = AttachCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AttachCatalogPrivateEndpointResponse> transformer = AttachCatalogPrivateEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AttachCatalogPrivateEndpointRequest, AttachCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AttachCatalogPrivateEndpointRequest, AttachCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeCatalogCompartmentResponse> changeCatalogCompartment(ChangeCatalogCompartmentRequest request, AsyncHandler<ChangeCatalogCompartmentRequest, ChangeCatalogCompartmentResponse> handler) {
        LOG.trace("Called async changeCatalogCompartment");
        ChangeCatalogCompartmentRequest interceptedRequest = ChangeCatalogCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCatalogCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeCatalogCompartmentResponse> transformer = ChangeCatalogCompartmentConverter.fromResponse();
        AsyncHandler<ChangeCatalogCompartmentRequest, ChangeCatalogCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCatalogCompartmentRequest, ChangeCatalogCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeCatalogPrivateEndpointCompartmentResponse> changeCatalogPrivateEndpointCompartment(ChangeCatalogPrivateEndpointCompartmentRequest request, AsyncHandler<ChangeCatalogPrivateEndpointCompartmentRequest, ChangeCatalogPrivateEndpointCompartmentResponse> handler) {
        LOG.trace("Called async changeCatalogPrivateEndpointCompartment");
        ChangeCatalogPrivateEndpointCompartmentRequest interceptedRequest = ChangeCatalogPrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCatalogPrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeCatalogPrivateEndpointCompartmentResponse> transformer = ChangeCatalogPrivateEndpointCompartmentConverter.fromResponse();
        AsyncHandler<ChangeCatalogPrivateEndpointCompartmentRequest, ChangeCatalogPrivateEndpointCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCatalogPrivateEndpointCompartmentRequest, ChangeCatalogPrivateEndpointCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAttributeResponse> createAttribute(CreateAttributeRequest request, AsyncHandler<CreateAttributeRequest, CreateAttributeResponse> handler) {
        LOG.trace("Called async createAttribute");
        CreateAttributeRequest interceptedRequest = CreateAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAttributeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateAttributeResponse> transformer = CreateAttributeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAttributeRequest, CreateAttributeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAttributeRequest, CreateAttributeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAttributeTagResponse> createAttributeTag(CreateAttributeTagRequest request, AsyncHandler<CreateAttributeTagRequest, CreateAttributeTagResponse> handler) {
        LOG.trace("Called async createAttributeTag");
        CreateAttributeTagRequest interceptedRequest = CreateAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateAttributeTagResponse> transformer = CreateAttributeTagConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAttributeTagRequest, CreateAttributeTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAttributeTagRequest, CreateAttributeTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCatalogResponse> createCatalog(CreateCatalogRequest request, AsyncHandler<CreateCatalogRequest, CreateCatalogResponse> handler) {
        LOG.trace("Called async createCatalog");
        CreateCatalogRequest interceptedRequest = CreateCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCatalogConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCatalogResponse> transformer = CreateCatalogConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCatalogRequest, CreateCatalogResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCatalogRequest, CreateCatalogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCatalogPrivateEndpointResponse> createCatalogPrivateEndpoint(CreateCatalogPrivateEndpointRequest request, AsyncHandler<CreateCatalogPrivateEndpointRequest, CreateCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async createCatalogPrivateEndpoint");
        CreateCatalogPrivateEndpointRequest interceptedRequest = CreateCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCatalogPrivateEndpointResponse> transformer = CreateCatalogPrivateEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCatalogPrivateEndpointRequest, CreateCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCatalogPrivateEndpointRequest, CreateCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        LOG.trace("Called async createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectionRequest, CreateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCustomPropertyResponse> createCustomProperty(CreateCustomPropertyRequest request, AsyncHandler<CreateCustomPropertyRequest, CreateCustomPropertyResponse> handler) {
        LOG.trace("Called async createCustomProperty");
        CreateCustomPropertyRequest interceptedRequest = CreateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCustomPropertyResponse> transformer = CreateCustomPropertyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCustomPropertyRequest, CreateCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCustomPropertyRequest, CreateCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataAssetResponse> createDataAsset(CreateDataAssetRequest request, AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handler) {
        LOG.trace("Called async createDataAsset");
        CreateDataAssetRequest interceptedRequest = CreateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDataAssetResponse> transformer = CreateDataAssetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataAssetRequest, CreateDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataAssetTagResponse> createDataAssetTag(CreateDataAssetTagRequest request, AsyncHandler<CreateDataAssetTagRequest, CreateDataAssetTagResponse> handler) {
        LOG.trace("Called async createDataAssetTag");
        CreateDataAssetTagRequest interceptedRequest = CreateDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDataAssetTagResponse> transformer = CreateDataAssetTagConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataAssetTagRequest, CreateDataAssetTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataAssetTagRequest, CreateDataAssetTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateEntityResponse> createEntity(CreateEntityRequest request, AsyncHandler<CreateEntityRequest, CreateEntityResponse> handler) {
        LOG.trace("Called async createEntity");
        CreateEntityRequest interceptedRequest = CreateEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateEntityResponse> transformer = CreateEntityConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateEntityRequest, CreateEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateEntityRequest, CreateEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateEntityTagResponse> createEntityTag(CreateEntityTagRequest request, AsyncHandler<CreateEntityTagRequest, CreateEntityTagResponse> handler) {
        LOG.trace("Called async createEntityTag");
        CreateEntityTagRequest interceptedRequest = CreateEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateEntityTagResponse> transformer = CreateEntityTagConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateEntityTagRequest, CreateEntityTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateEntityTagRequest, CreateEntityTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateFolderResponse> createFolder(CreateFolderRequest request, AsyncHandler<CreateFolderRequest, CreateFolderResponse> handler) {
        LOG.trace("Called async createFolder");
        CreateFolderRequest interceptedRequest = CreateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateFolderResponse> transformer = CreateFolderConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateFolderRequest, CreateFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateFolderRequest, CreateFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateFolderTagResponse> createFolderTag(CreateFolderTagRequest request, AsyncHandler<CreateFolderTagRequest, CreateFolderTagResponse> handler) {
        LOG.trace("Called async createFolderTag");
        CreateFolderTagRequest interceptedRequest = CreateFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateFolderTagResponse> transformer = CreateFolderTagConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateFolderTagRequest, CreateFolderTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateFolderTagRequest, CreateFolderTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateGlossaryResponse> createGlossary(CreateGlossaryRequest request, AsyncHandler<CreateGlossaryRequest, CreateGlossaryResponse> handler) {
        LOG.trace("Called async createGlossary");
        CreateGlossaryRequest interceptedRequest = CreateGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateGlossaryResponse> transformer = CreateGlossaryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateGlossaryRequest, CreateGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateGlossaryRequest, CreateGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        LOG.trace("Called async createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobRequest, CreateJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobRequest, CreateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobDefinitionResponse> createJobDefinition(CreateJobDefinitionRequest request, AsyncHandler<CreateJobDefinitionRequest, CreateJobDefinitionResponse> handler) {
        LOG.trace("Called async createJobDefinition");
        CreateJobDefinitionRequest interceptedRequest = CreateJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobDefinitionResponse> transformer = CreateJobDefinitionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobDefinitionRequest, CreateJobDefinitionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobDefinitionRequest, CreateJobDefinitionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobExecutionResponse> createJobExecution(CreateJobExecutionRequest request, AsyncHandler<CreateJobExecutionRequest, CreateJobExecutionResponse> handler) {
        LOG.trace("Called async createJobExecution");
        CreateJobExecutionRequest interceptedRequest = CreateJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateJobExecutionResponse> transformer = CreateJobExecutionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobExecutionRequest, CreateJobExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobExecutionRequest, CreateJobExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest request, AsyncHandler<CreateNamespaceRequest, CreateNamespaceResponse> handler) {
        LOG.trace("Called async createNamespace");
        CreateNamespaceRequest interceptedRequest = CreateNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateNamespaceResponse> transformer = CreateNamespaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateNamespaceRequest, CreateNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateNamespaceRequest, CreateNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePatternResponse> createPattern(CreatePatternRequest request, AsyncHandler<CreatePatternRequest, CreatePatternResponse> handler) {
        LOG.trace("Called async createPattern");
        CreatePatternRequest interceptedRequest = CreatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePatternConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePatternResponse> transformer = CreatePatternConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePatternRequest, CreatePatternResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePatternRequest, CreatePatternResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTermResponse> createTerm(CreateTermRequest request, AsyncHandler<CreateTermRequest, CreateTermResponse> handler) {
        LOG.trace("Called async createTerm");
        CreateTermRequest interceptedRequest = CreateTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTermConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTermResponse> transformer = CreateTermConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTermRequest, CreateTermResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTermRequest, CreateTermResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTermRelationshipResponse> createTermRelationship(CreateTermRelationshipRequest request, AsyncHandler<CreateTermRelationshipRequest, CreateTermRelationshipResponse> handler) {
        LOG.trace("Called async createTermRelationship");
        CreateTermRelationshipRequest interceptedRequest = CreateTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTermRelationshipResponse> transformer = CreateTermRelationshipConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTermRelationshipRequest, CreateTermRelationshipResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTermRelationshipRequest, CreateTermRelationshipResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAttributeResponse> deleteAttribute(DeleteAttributeRequest request, AsyncHandler<DeleteAttributeRequest, DeleteAttributeResponse> handler) {
        LOG.trace("Called async deleteAttribute");
        DeleteAttributeRequest interceptedRequest = DeleteAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAttributeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteAttributeResponse> transformer = DeleteAttributeConverter.fromResponse();
        AsyncHandler<DeleteAttributeRequest, DeleteAttributeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAttributeRequest, DeleteAttributeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAttributeTagResponse> deleteAttributeTag(DeleteAttributeTagRequest request, AsyncHandler<DeleteAttributeTagRequest, DeleteAttributeTagResponse> handler) {
        LOG.trace("Called async deleteAttributeTag");
        DeleteAttributeTagRequest interceptedRequest = DeleteAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteAttributeTagResponse> transformer = DeleteAttributeTagConverter.fromResponse();
        AsyncHandler<DeleteAttributeTagRequest, DeleteAttributeTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAttributeTagRequest, DeleteAttributeTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCatalogResponse> deleteCatalog(DeleteCatalogRequest request, AsyncHandler<DeleteCatalogRequest, DeleteCatalogResponse> handler) {
        LOG.trace("Called async deleteCatalog");
        DeleteCatalogRequest interceptedRequest = DeleteCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCatalogConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCatalogResponse> transformer = DeleteCatalogConverter.fromResponse();
        AsyncHandler<DeleteCatalogRequest, DeleteCatalogResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCatalogRequest, DeleteCatalogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCatalogPrivateEndpointResponse> deleteCatalogPrivateEndpoint(DeleteCatalogPrivateEndpointRequest request, AsyncHandler<DeleteCatalogPrivateEndpointRequest, DeleteCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async deleteCatalogPrivateEndpoint");
        DeleteCatalogPrivateEndpointRequest interceptedRequest = DeleteCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCatalogPrivateEndpointResponse> transformer = DeleteCatalogPrivateEndpointConverter.fromResponse();
        AsyncHandler<DeleteCatalogPrivateEndpointRequest, DeleteCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCatalogPrivateEndpointRequest, DeleteCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        LOG.trace("Called async deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectionRequest, DeleteConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCustomPropertyResponse> deleteCustomProperty(DeleteCustomPropertyRequest request, AsyncHandler<DeleteCustomPropertyRequest, DeleteCustomPropertyResponse> handler) {
        LOG.trace("Called async deleteCustomProperty");
        DeleteCustomPropertyRequest interceptedRequest = DeleteCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCustomPropertyResponse> transformer = DeleteCustomPropertyConverter.fromResponse();
        AsyncHandler<DeleteCustomPropertyRequest, DeleteCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCustomPropertyRequest, DeleteCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataAssetResponse> deleteDataAsset(DeleteDataAssetRequest request, AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handler) {
        LOG.trace("Called async deleteDataAsset");
        DeleteDataAssetRequest interceptedRequest = DeleteDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDataAssetResponse> transformer = DeleteDataAssetConverter.fromResponse();
        AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataAssetRequest, DeleteDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataAssetTagResponse> deleteDataAssetTag(DeleteDataAssetTagRequest request, AsyncHandler<DeleteDataAssetTagRequest, DeleteDataAssetTagResponse> handler) {
        LOG.trace("Called async deleteDataAssetTag");
        DeleteDataAssetTagRequest interceptedRequest = DeleteDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDataAssetTagResponse> transformer = DeleteDataAssetTagConverter.fromResponse();
        AsyncHandler<DeleteDataAssetTagRequest, DeleteDataAssetTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataAssetTagRequest, DeleteDataAssetTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteEntityResponse> deleteEntity(DeleteEntityRequest request, AsyncHandler<DeleteEntityRequest, DeleteEntityResponse> handler) {
        LOG.trace("Called async deleteEntity");
        DeleteEntityRequest interceptedRequest = DeleteEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteEntityResponse> transformer = DeleteEntityConverter.fromResponse();
        AsyncHandler<DeleteEntityRequest, DeleteEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteEntityRequest, DeleteEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteEntityTagResponse> deleteEntityTag(DeleteEntityTagRequest request, AsyncHandler<DeleteEntityTagRequest, DeleteEntityTagResponse> handler) {
        LOG.trace("Called async deleteEntityTag");
        DeleteEntityTagRequest interceptedRequest = DeleteEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEntityTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteEntityTagResponse> transformer = DeleteEntityTagConverter.fromResponse();
        AsyncHandler<DeleteEntityTagRequest, DeleteEntityTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteEntityTagRequest, DeleteEntityTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFolderResponse> deleteFolder(DeleteFolderRequest request, AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handler) {
        LOG.trace("Called async deleteFolder");
        DeleteFolderRequest interceptedRequest = DeleteFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteFolderResponse> transformer = DeleteFolderConverter.fromResponse();
        AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFolderRequest, DeleteFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFolderTagResponse> deleteFolderTag(DeleteFolderTagRequest request, AsyncHandler<DeleteFolderTagRequest, DeleteFolderTagResponse> handler) {
        LOG.trace("Called async deleteFolderTag");
        DeleteFolderTagRequest interceptedRequest = DeleteFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteFolderTagResponse> transformer = DeleteFolderTagConverter.fromResponse();
        AsyncHandler<DeleteFolderTagRequest, DeleteFolderTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFolderTagRequest, DeleteFolderTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteGlossaryResponse> deleteGlossary(DeleteGlossaryRequest request, AsyncHandler<DeleteGlossaryRequest, DeleteGlossaryResponse> handler) {
        LOG.trace("Called async deleteGlossary");
        DeleteGlossaryRequest interceptedRequest = DeleteGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteGlossaryResponse> transformer = DeleteGlossaryConverter.fromResponse();
        AsyncHandler<DeleteGlossaryRequest, DeleteGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteGlossaryRequest, DeleteGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteJobResponse> deleteJob(DeleteJobRequest request, AsyncHandler<DeleteJobRequest, DeleteJobResponse> handler) {
        LOG.trace("Called async deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        AsyncHandler<DeleteJobRequest, DeleteJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteJobRequest, DeleteJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteJobDefinitionResponse> deleteJobDefinition(DeleteJobDefinitionRequest request, AsyncHandler<DeleteJobDefinitionRequest, DeleteJobDefinitionResponse> handler) {
        LOG.trace("Called async deleteJobDefinition");
        DeleteJobDefinitionRequest interceptedRequest = DeleteJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteJobDefinitionResponse> transformer = DeleteJobDefinitionConverter.fromResponse();
        AsyncHandler<DeleteJobDefinitionRequest, DeleteJobDefinitionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteJobDefinitionRequest, DeleteJobDefinitionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest request, AsyncHandler<DeleteNamespaceRequest, DeleteNamespaceResponse> handler) {
        LOG.trace("Called async deleteNamespace");
        DeleteNamespaceRequest interceptedRequest = DeleteNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteNamespaceResponse> transformer = DeleteNamespaceConverter.fromResponse();
        AsyncHandler<DeleteNamespaceRequest, DeleteNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteNamespaceRequest, DeleteNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePatternResponse> deletePattern(DeletePatternRequest request, AsyncHandler<DeletePatternRequest, DeletePatternResponse> handler) {
        LOG.trace("Called async deletePattern");
        DeletePatternRequest interceptedRequest = DeletePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePatternConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePatternResponse> transformer = DeletePatternConverter.fromResponse();
        AsyncHandler<DeletePatternRequest, DeletePatternResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePatternRequest, DeletePatternResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTermResponse> deleteTerm(DeleteTermRequest request, AsyncHandler<DeleteTermRequest, DeleteTermResponse> handler) {
        LOG.trace("Called async deleteTerm");
        DeleteTermRequest interceptedRequest = DeleteTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTermConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTermResponse> transformer = DeleteTermConverter.fromResponse();
        AsyncHandler<DeleteTermRequest, DeleteTermResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTermRequest, DeleteTermResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTermRelationshipResponse> deleteTermRelationship(DeleteTermRelationshipRequest request, AsyncHandler<DeleteTermRelationshipRequest, DeleteTermRelationshipResponse> handler) {
        LOG.trace("Called async deleteTermRelationship");
        DeleteTermRelationshipRequest interceptedRequest = DeleteTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTermRelationshipResponse> transformer = DeleteTermRelationshipConverter.fromResponse();
        AsyncHandler<DeleteTermRelationshipRequest, DeleteTermRelationshipResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTermRelationshipRequest, DeleteTermRelationshipResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetachCatalogPrivateEndpointResponse> detachCatalogPrivateEndpoint(DetachCatalogPrivateEndpointRequest request, AsyncHandler<DetachCatalogPrivateEndpointRequest, DetachCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async detachCatalogPrivateEndpoint");
        DetachCatalogPrivateEndpointRequest interceptedRequest = DetachCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DetachCatalogPrivateEndpointResponse> transformer = DetachCatalogPrivateEndpointConverter.fromResponse();
        AsyncHandler<DetachCatalogPrivateEndpointRequest, DetachCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetachCatalogPrivateEndpointRequest, DetachCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DisassociateCustomPropertyResponse> disassociateCustomProperty(DisassociateCustomPropertyRequest request, AsyncHandler<DisassociateCustomPropertyRequest, DisassociateCustomPropertyResponse> handler) {
        LOG.trace("Called async disassociateCustomProperty");
        DisassociateCustomPropertyRequest interceptedRequest = DisassociateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisassociateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DisassociateCustomPropertyResponse> transformer = DisassociateCustomPropertyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DisassociateCustomPropertyRequest, DisassociateCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DisassociateCustomPropertyRequest, DisassociateCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExpandTreeForGlossaryResponse> expandTreeForGlossary(ExpandTreeForGlossaryRequest request, AsyncHandler<ExpandTreeForGlossaryRequest, ExpandTreeForGlossaryResponse> handler) {
        LOG.trace("Called async expandTreeForGlossary");
        ExpandTreeForGlossaryRequest interceptedRequest = ExpandTreeForGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExpandTreeForGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExpandTreeForGlossaryResponse> transformer = ExpandTreeForGlossaryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExpandTreeForGlossaryRequest, ExpandTreeForGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExpandTreeForGlossaryRequest, ExpandTreeForGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExportGlossaryResponse> exportGlossary(ExportGlossaryRequest request, AsyncHandler<ExportGlossaryRequest, ExportGlossaryResponse> handler) {
        LOG.trace("Called async exportGlossary");
        ExportGlossaryRequest interceptedRequest = ExportGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExportGlossaryResponse> transformer = ExportGlossaryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExportGlossaryRequest, ExportGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExportGlossaryRequest, ExportGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAttributeResponse> getAttribute(GetAttributeRequest request, AsyncHandler<GetAttributeRequest, GetAttributeResponse> handler) {
        LOG.trace("Called async getAttribute");
        GetAttributeRequest interceptedRequest = GetAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAttributeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetAttributeResponse> transformer = GetAttributeConverter.fromResponse();
        AsyncHandler<GetAttributeRequest, GetAttributeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAttributeRequest, GetAttributeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAttributeTagResponse> getAttributeTag(GetAttributeTagRequest request, AsyncHandler<GetAttributeTagRequest, GetAttributeTagResponse> handler) {
        LOG.trace("Called async getAttributeTag");
        GetAttributeTagRequest interceptedRequest = GetAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetAttributeTagResponse> transformer = GetAttributeTagConverter.fromResponse();
        AsyncHandler<GetAttributeTagRequest, GetAttributeTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAttributeTagRequest, GetAttributeTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCatalogResponse> getCatalog(GetCatalogRequest request, AsyncHandler<GetCatalogRequest, GetCatalogResponse> handler) {
        LOG.trace("Called async getCatalog");
        GetCatalogRequest interceptedRequest = GetCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCatalogConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCatalogResponse> transformer = GetCatalogConverter.fromResponse();
        AsyncHandler<GetCatalogRequest, GetCatalogResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCatalogRequest, GetCatalogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCatalogPrivateEndpointResponse> getCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request, AsyncHandler<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async getCatalogPrivateEndpoint");
        GetCatalogPrivateEndpointRequest interceptedRequest = GetCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCatalogPrivateEndpointResponse> transformer = GetCatalogPrivateEndpointConverter.fromResponse();
        AsyncHandler<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        LOG.trace("Called async getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        AsyncHandler<GetConnectionRequest, GetConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectionRequest, GetConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCustomPropertyResponse> getCustomProperty(GetCustomPropertyRequest request, AsyncHandler<GetCustomPropertyRequest, GetCustomPropertyResponse> handler) {
        LOG.trace("Called async getCustomProperty");
        GetCustomPropertyRequest interceptedRequest = GetCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCustomPropertyResponse> transformer = GetCustomPropertyConverter.fromResponse();
        AsyncHandler<GetCustomPropertyRequest, GetCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCustomPropertyRequest, GetCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataAssetResponse> getDataAsset(GetDataAssetRequest request, AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handler) {
        LOG.trace("Called async getDataAsset");
        GetDataAssetRequest interceptedRequest = GetDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataAssetResponse> transformer = GetDataAssetConverter.fromResponse();
        AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataAssetRequest, GetDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataAssetTagResponse> getDataAssetTag(GetDataAssetTagRequest request, AsyncHandler<GetDataAssetTagRequest, GetDataAssetTagResponse> handler) {
        LOG.trace("Called async getDataAssetTag");
        GetDataAssetTagRequest interceptedRequest = GetDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataAssetTagResponse> transformer = GetDataAssetTagConverter.fromResponse();
        AsyncHandler<GetDataAssetTagRequest, GetDataAssetTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataAssetTagRequest, GetDataAssetTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEntityResponse> getEntity(GetEntityRequest request, AsyncHandler<GetEntityRequest, GetEntityResponse> handler) {
        LOG.trace("Called async getEntity");
        GetEntityRequest interceptedRequest = GetEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetEntityResponse> transformer = GetEntityConverter.fromResponse();
        AsyncHandler<GetEntityRequest, GetEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEntityRequest, GetEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEntityTagResponse> getEntityTag(GetEntityTagRequest request, AsyncHandler<GetEntityTagRequest, GetEntityTagResponse> handler) {
        LOG.trace("Called async getEntityTag");
        GetEntityTagRequest interceptedRequest = GetEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEntityTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetEntityTagResponse> transformer = GetEntityTagConverter.fromResponse();
        AsyncHandler<GetEntityTagRequest, GetEntityTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEntityTagRequest, GetEntityTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFolderResponse> getFolder(GetFolderRequest request, AsyncHandler<GetFolderRequest, GetFolderResponse> handler) {
        LOG.trace("Called async getFolder");
        GetFolderRequest interceptedRequest = GetFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFolderResponse> transformer = GetFolderConverter.fromResponse();
        AsyncHandler<GetFolderRequest, GetFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFolderRequest, GetFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFolderTagResponse> getFolderTag(GetFolderTagRequest request, AsyncHandler<GetFolderTagRequest, GetFolderTagResponse> handler) {
        LOG.trace("Called async getFolderTag");
        GetFolderTagRequest interceptedRequest = GetFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderTagConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFolderTagResponse> transformer = GetFolderTagConverter.fromResponse();
        AsyncHandler<GetFolderTagRequest, GetFolderTagResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFolderTagRequest, GetFolderTagResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetGlossaryResponse> getGlossary(GetGlossaryRequest request, AsyncHandler<GetGlossaryRequest, GetGlossaryResponse> handler) {
        LOG.trace("Called async getGlossary");
        GetGlossaryRequest interceptedRequest = GetGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetGlossaryResponse> transformer = GetGlossaryConverter.fromResponse();
        AsyncHandler<GetGlossaryRequest, GetGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetGlossaryRequest, GetGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        LOG.trace("Called async getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        AsyncHandler<GetJobRequest, GetJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRequest, GetJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobDefinitionResponse> getJobDefinition(GetJobDefinitionRequest request, AsyncHandler<GetJobDefinitionRequest, GetJobDefinitionResponse> handler) {
        LOG.trace("Called async getJobDefinition");
        GetJobDefinitionRequest interceptedRequest = GetJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobDefinitionResponse> transformer = GetJobDefinitionConverter.fromResponse();
        AsyncHandler<GetJobDefinitionRequest, GetJobDefinitionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobDefinitionRequest, GetJobDefinitionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobExecutionResponse> getJobExecution(GetJobExecutionRequest request, AsyncHandler<GetJobExecutionRequest, GetJobExecutionResponse> handler) {
        LOG.trace("Called async getJobExecution");
        GetJobExecutionRequest interceptedRequest = GetJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobExecutionResponse> transformer = GetJobExecutionConverter.fromResponse();
        AsyncHandler<GetJobExecutionRequest, GetJobExecutionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobExecutionRequest, GetJobExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobLogResponse> getJobLog(GetJobLogRequest request, AsyncHandler<GetJobLogRequest, GetJobLogResponse> handler) {
        LOG.trace("Called async getJobLog");
        GetJobLogRequest interceptedRequest = GetJobLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobLogResponse> transformer = GetJobLogConverter.fromResponse();
        AsyncHandler<GetJobLogRequest, GetJobLogResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobLogRequest, GetJobLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobMetricsResponse> getJobMetrics(GetJobMetricsRequest request, AsyncHandler<GetJobMetricsRequest, GetJobMetricsResponse> handler) {
        LOG.trace("Called async getJobMetrics");
        GetJobMetricsRequest interceptedRequest = GetJobMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobMetricsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJobMetricsResponse> transformer = GetJobMetricsConverter.fromResponse();
        AsyncHandler<GetJobMetricsRequest, GetJobMetricsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobMetricsRequest, GetJobMetricsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNamespaceResponse> getNamespace(GetNamespaceRequest request, AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handler) {
        LOG.trace("Called async getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNamespaceRequest, GetNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPatternResponse> getPattern(GetPatternRequest request, AsyncHandler<GetPatternRequest, GetPatternResponse> handler) {
        LOG.trace("Called async getPattern");
        GetPatternRequest interceptedRequest = GetPatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPatternConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPatternResponse> transformer = GetPatternConverter.fromResponse();
        AsyncHandler<GetPatternRequest, GetPatternResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPatternRequest, GetPatternResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTermResponse> getTerm(GetTermRequest request, AsyncHandler<GetTermRequest, GetTermResponse> handler) {
        LOG.trace("Called async getTerm");
        GetTermRequest interceptedRequest = GetTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTermConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTermResponse> transformer = GetTermConverter.fromResponse();
        AsyncHandler<GetTermRequest, GetTermResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTermRequest, GetTermResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTermRelationshipResponse> getTermRelationship(GetTermRelationshipRequest request, AsyncHandler<GetTermRelationshipRequest, GetTermRelationshipResponse> handler) {
        LOG.trace("Called async getTermRelationship");
        GetTermRelationshipRequest interceptedRequest = GetTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTermRelationshipResponse> transformer = GetTermRelationshipConverter.fromResponse();
        AsyncHandler<GetTermRelationshipRequest, GetTermRelationshipResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTermRelationshipRequest, GetTermRelationshipResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTypeResponse> getType(GetTypeRequest request, AsyncHandler<GetTypeRequest, GetTypeResponse> handler) {
        LOG.trace("Called async getType");
        GetTypeRequest interceptedRequest = GetTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTypeResponse> transformer = GetTypeConverter.fromResponse();
        AsyncHandler<GetTypeRequest, GetTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTypeRequest, GetTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportConnectionResponse> importConnection(ImportConnectionRequest request, AsyncHandler<ImportConnectionRequest, ImportConnectionResponse> handler) {
        LOG.trace("Called async importConnection");
        ImportConnectionRequest interceptedRequest = ImportConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ImportConnectionResponse> transformer = ImportConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ImportConnectionRequest, ImportConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportConnectionRequest, ImportConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportGlossaryResponse> importGlossary(ImportGlossaryRequest request, AsyncHandler<ImportGlossaryRequest, ImportGlossaryResponse> handler) {
        LOG.trace("Called async importGlossary");
        ImportGlossaryRequest interceptedRequest = ImportGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ImportGlossaryResponse> transformer = ImportGlossaryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ImportGlossaryRequest, ImportGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportGlossaryRequest, ImportGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAggregatedPhysicalEntitiesResponse> listAggregatedPhysicalEntities(ListAggregatedPhysicalEntitiesRequest request, AsyncHandler<ListAggregatedPhysicalEntitiesRequest, ListAggregatedPhysicalEntitiesResponse> handler) {
        LOG.trace("Called async listAggregatedPhysicalEntities");
        ListAggregatedPhysicalEntitiesRequest interceptedRequest = ListAggregatedPhysicalEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAggregatedPhysicalEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAggregatedPhysicalEntitiesResponse> transformer = ListAggregatedPhysicalEntitiesConverter.fromResponse();
        AsyncHandler<ListAggregatedPhysicalEntitiesRequest, ListAggregatedPhysicalEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAggregatedPhysicalEntitiesRequest, ListAggregatedPhysicalEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAttributeTagsResponse> listAttributeTags(ListAttributeTagsRequest request, AsyncHandler<ListAttributeTagsRequest, ListAttributeTagsResponse> handler) {
        LOG.trace("Called async listAttributeTags");
        ListAttributeTagsRequest interceptedRequest = ListAttributeTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAttributeTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAttributeTagsResponse> transformer = ListAttributeTagsConverter.fromResponse();
        AsyncHandler<ListAttributeTagsRequest, ListAttributeTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAttributeTagsRequest, ListAttributeTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAttributesResponse> listAttributes(ListAttributesRequest request, AsyncHandler<ListAttributesRequest, ListAttributesResponse> handler) {
        LOG.trace("Called async listAttributes");
        ListAttributesRequest interceptedRequest = ListAttributesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAttributesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAttributesResponse> transformer = ListAttributesConverter.fromResponse();
        AsyncHandler<ListAttributesRequest, ListAttributesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAttributesRequest, ListAttributesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCatalogPrivateEndpointsResponse> listCatalogPrivateEndpoints(ListCatalogPrivateEndpointsRequest request, AsyncHandler<ListCatalogPrivateEndpointsRequest, ListCatalogPrivateEndpointsResponse> handler) {
        LOG.trace("Called async listCatalogPrivateEndpoints");
        ListCatalogPrivateEndpointsRequest interceptedRequest = ListCatalogPrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCatalogPrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCatalogPrivateEndpointsResponse> transformer = ListCatalogPrivateEndpointsConverter.fromResponse();
        AsyncHandler<ListCatalogPrivateEndpointsRequest, ListCatalogPrivateEndpointsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCatalogPrivateEndpointsRequest, ListCatalogPrivateEndpointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCatalogsResponse> listCatalogs(ListCatalogsRequest request, AsyncHandler<ListCatalogsRequest, ListCatalogsResponse> handler) {
        LOG.trace("Called async listCatalogs");
        ListCatalogsRequest interceptedRequest = ListCatalogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCatalogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCatalogsResponse> transformer = ListCatalogsConverter.fromResponse();
        AsyncHandler<ListCatalogsRequest, ListCatalogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCatalogsRequest, ListCatalogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        LOG.trace("Called async listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectionsRequest, ListConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCustomPropertiesResponse> listCustomProperties(ListCustomPropertiesRequest request, AsyncHandler<ListCustomPropertiesRequest, ListCustomPropertiesResponse> handler) {
        LOG.trace("Called async listCustomProperties");
        ListCustomPropertiesRequest interceptedRequest = ListCustomPropertiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomPropertiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCustomPropertiesResponse> transformer = ListCustomPropertiesConverter.fromResponse();
        AsyncHandler<ListCustomPropertiesRequest, ListCustomPropertiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCustomPropertiesRequest, ListCustomPropertiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataAssetTagsResponse> listDataAssetTags(ListDataAssetTagsRequest request, AsyncHandler<ListDataAssetTagsRequest, ListDataAssetTagsResponse> handler) {
        LOG.trace("Called async listDataAssetTags");
        ListDataAssetTagsRequest interceptedRequest = ListDataAssetTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataAssetTagsResponse> transformer = ListDataAssetTagsConverter.fromResponse();
        AsyncHandler<ListDataAssetTagsRequest, ListDataAssetTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataAssetTagsRequest, ListDataAssetTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataAssetsResponse> listDataAssets(ListDataAssetsRequest request, AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handler) {
        LOG.trace("Called async listDataAssets");
        ListDataAssetsRequest interceptedRequest = ListDataAssetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataAssetsResponse> transformer = ListDataAssetsConverter.fromResponse();
        AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataAssetsRequest, ListDataAssetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDerivedLogicalEntitiesResponse> listDerivedLogicalEntities(ListDerivedLogicalEntitiesRequest request, AsyncHandler<ListDerivedLogicalEntitiesRequest, ListDerivedLogicalEntitiesResponse> handler) {
        LOG.trace("Called async listDerivedLogicalEntities");
        ListDerivedLogicalEntitiesRequest interceptedRequest = ListDerivedLogicalEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDerivedLogicalEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDerivedLogicalEntitiesResponse> transformer = ListDerivedLogicalEntitiesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ListDerivedLogicalEntitiesRequest, ListDerivedLogicalEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDerivedLogicalEntitiesRequest, ListDerivedLogicalEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEntitiesResponse> listEntities(ListEntitiesRequest request, AsyncHandler<ListEntitiesRequest, ListEntitiesResponse> handler) {
        LOG.trace("Called async listEntities");
        ListEntitiesRequest interceptedRequest = ListEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListEntitiesResponse> transformer = ListEntitiesConverter.fromResponse();
        AsyncHandler<ListEntitiesRequest, ListEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEntitiesRequest, ListEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEntityTagsResponse> listEntityTags(ListEntityTagsRequest request, AsyncHandler<ListEntityTagsRequest, ListEntityTagsResponse> handler) {
        LOG.trace("Called async listEntityTags");
        ListEntityTagsRequest interceptedRequest = ListEntityTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntityTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListEntityTagsResponse> transformer = ListEntityTagsConverter.fromResponse();
        AsyncHandler<ListEntityTagsRequest, ListEntityTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEntityTagsRequest, ListEntityTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFolderTagsResponse> listFolderTags(ListFolderTagsRequest request, AsyncHandler<ListFolderTagsRequest, ListFolderTagsResponse> handler) {
        LOG.trace("Called async listFolderTags");
        ListFolderTagsRequest interceptedRequest = ListFolderTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFolderTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListFolderTagsResponse> transformer = ListFolderTagsConverter.fromResponse();
        AsyncHandler<ListFolderTagsRequest, ListFolderTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFolderTagsRequest, ListFolderTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFoldersResponse> listFolders(ListFoldersRequest request, AsyncHandler<ListFoldersRequest, ListFoldersResponse> handler) {
        LOG.trace("Called async listFolders");
        ListFoldersRequest interceptedRequest = ListFoldersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFoldersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListFoldersResponse> transformer = ListFoldersConverter.fromResponse();
        AsyncHandler<ListFoldersRequest, ListFoldersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFoldersRequest, ListFoldersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListGlossariesResponse> listGlossaries(ListGlossariesRequest request, AsyncHandler<ListGlossariesRequest, ListGlossariesResponse> handler) {
        LOG.trace("Called async listGlossaries");
        ListGlossariesRequest interceptedRequest = ListGlossariesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGlossariesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListGlossariesResponse> transformer = ListGlossariesConverter.fromResponse();
        AsyncHandler<ListGlossariesRequest, ListGlossariesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListGlossariesRequest, ListGlossariesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobDefinitionsResponse> listJobDefinitions(ListJobDefinitionsRequest request, AsyncHandler<ListJobDefinitionsRequest, ListJobDefinitionsResponse> handler) {
        LOG.trace("Called async listJobDefinitions");
        ListJobDefinitionsRequest interceptedRequest = ListJobDefinitionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobDefinitionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobDefinitionsResponse> transformer = ListJobDefinitionsConverter.fromResponse();
        AsyncHandler<ListJobDefinitionsRequest, ListJobDefinitionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobDefinitionsRequest, ListJobDefinitionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobExecutionsResponse> listJobExecutions(ListJobExecutionsRequest request, AsyncHandler<ListJobExecutionsRequest, ListJobExecutionsResponse> handler) {
        LOG.trace("Called async listJobExecutions");
        ListJobExecutionsRequest interceptedRequest = ListJobExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobExecutionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobExecutionsResponse> transformer = ListJobExecutionsConverter.fromResponse();
        AsyncHandler<ListJobExecutionsRequest, ListJobExecutionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobExecutionsRequest, ListJobExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobLogsResponse> listJobLogs(ListJobLogsRequest request, AsyncHandler<ListJobLogsRequest, ListJobLogsResponse> handler) {
        LOG.trace("Called async listJobLogs");
        ListJobLogsRequest interceptedRequest = ListJobLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobLogsResponse> transformer = ListJobLogsConverter.fromResponse();
        AsyncHandler<ListJobLogsRequest, ListJobLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobLogsRequest, ListJobLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobMetricsResponse> listJobMetrics(ListJobMetricsRequest request, AsyncHandler<ListJobMetricsRequest, ListJobMetricsResponse> handler) {
        LOG.trace("Called async listJobMetrics");
        ListJobMetricsRequest interceptedRequest = ListJobMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobMetricsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobMetricsResponse> transformer = ListJobMetricsConverter.fromResponse();
        AsyncHandler<ListJobMetricsRequest, ListJobMetricsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobMetricsRequest, ListJobMetricsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        LOG.trace("Called async listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        AsyncHandler<ListJobsRequest, ListJobsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobsRequest, ListJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNamespacesResponse> listNamespaces(ListNamespacesRequest request, AsyncHandler<ListNamespacesRequest, ListNamespacesResponse> handler) {
        LOG.trace("Called async listNamespaces");
        ListNamespacesRequest interceptedRequest = ListNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNamespacesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListNamespacesResponse> transformer = ListNamespacesConverter.fromResponse();
        AsyncHandler<ListNamespacesRequest, ListNamespacesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNamespacesRequest, ListNamespacesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPatternsResponse> listPatterns(ListPatternsRequest request, AsyncHandler<ListPatternsRequest, ListPatternsResponse> handler) {
        LOG.trace("Called async listPatterns");
        ListPatternsRequest interceptedRequest = ListPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatternsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPatternsResponse> transformer = ListPatternsConverter.fromResponse();
        AsyncHandler<ListPatternsRequest, ListPatternsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPatternsRequest, ListPatternsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRulesResponse> listRules(ListRulesRequest request, AsyncHandler<ListRulesRequest, ListRulesResponse> handler) {
        LOG.trace("Called async listRules");
        ListRulesRequest interceptedRequest = ListRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRulesResponse> transformer = ListRulesConverter.fromResponse();
        AsyncHandler<ListRulesRequest, ListRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRulesRequest, ListRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTagsResponse> listTags(ListTagsRequest request, AsyncHandler<ListTagsRequest, ListTagsResponse> handler) {
        LOG.trace("Called async listTags");
        ListTagsRequest interceptedRequest = ListTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTagsResponse> transformer = ListTagsConverter.fromResponse();
        AsyncHandler<ListTagsRequest, ListTagsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTagsRequest, ListTagsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTermRelationshipsResponse> listTermRelationships(ListTermRelationshipsRequest request, AsyncHandler<ListTermRelationshipsRequest, ListTermRelationshipsResponse> handler) {
        LOG.trace("Called async listTermRelationships");
        ListTermRelationshipsRequest interceptedRequest = ListTermRelationshipsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTermRelationshipsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTermRelationshipsResponse> transformer = ListTermRelationshipsConverter.fromResponse();
        AsyncHandler<ListTermRelationshipsRequest, ListTermRelationshipsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTermRelationshipsRequest, ListTermRelationshipsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTermsResponse> listTerms(ListTermsRequest request, AsyncHandler<ListTermsRequest, ListTermsResponse> handler) {
        LOG.trace("Called async listTerms");
        ListTermsRequest interceptedRequest = ListTermsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTermsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTermsResponse> transformer = ListTermsConverter.fromResponse();
        AsyncHandler<ListTermsRequest, ListTermsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTermsRequest, ListTermsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTypesResponse> listTypes(ListTypesRequest request, AsyncHandler<ListTypesRequest, ListTypesResponse> handler) {
        LOG.trace("Called async listTypes");
        ListTypesRequest interceptedRequest = ListTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTypesResponse> transformer = ListTypesConverter.fromResponse();
        AsyncHandler<ListTypesRequest, ListTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTypesRequest, ListTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ObjectStatsResponse> objectStats(ObjectStatsRequest request, AsyncHandler<ObjectStatsRequest, ObjectStatsResponse> handler) {
        LOG.trace("Called async objectStats");
        ObjectStatsRequest interceptedRequest = ObjectStatsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ObjectStatsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ObjectStatsResponse> transformer = ObjectStatsConverter.fromResponse();
        AsyncHandler<ObjectStatsRequest, ObjectStatsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ObjectStatsRequest, ObjectStatsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ParseConnectionResponse> parseConnection(ParseConnectionRequest request, AsyncHandler<ParseConnectionRequest, ParseConnectionResponse> handler) {
        LOG.trace("Called async parseConnection");
        ParseConnectionRequest interceptedRequest = ParseConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ParseConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ParseConnectionResponse> transformer = ParseConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ParseConnectionRequest, ParseConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ParseConnectionRequest, ParseConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ProcessRecommendationResponse> processRecommendation(ProcessRecommendationRequest request, AsyncHandler<ProcessRecommendationRequest, ProcessRecommendationResponse> handler) {
        LOG.trace("Called async processRecommendation");
        ProcessRecommendationRequest interceptedRequest = ProcessRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ProcessRecommendationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ProcessRecommendationResponse> transformer = ProcessRecommendationConverter.fromResponse();
        AsyncHandler<ProcessRecommendationRequest, ProcessRecommendationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ProcessRecommendationRequest, ProcessRecommendationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RecommendationsResponse> recommendations(RecommendationsRequest request, AsyncHandler<RecommendationsRequest, RecommendationsResponse> handler) {
        LOG.trace("Called async recommendations");
        RecommendationsRequest interceptedRequest = RecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecommendationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RecommendationsResponse> transformer = RecommendationsConverter.fromResponse();
        AsyncHandler<RecommendationsRequest, RecommendationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RecommendationsRequest, RecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveDataSelectorPatternsResponse> removeDataSelectorPatterns(RemoveDataSelectorPatternsRequest request, AsyncHandler<RemoveDataSelectorPatternsRequest, RemoveDataSelectorPatternsResponse> handler) {
        LOG.trace("Called async removeDataSelectorPatterns");
        RemoveDataSelectorPatternsRequest interceptedRequest = RemoveDataSelectorPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveDataSelectorPatternsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RemoveDataSelectorPatternsResponse> transformer = RemoveDataSelectorPatternsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveDataSelectorPatternsRequest, RemoveDataSelectorPatternsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveDataSelectorPatternsRequest, RemoveDataSelectorPatternsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SearchCriteriaResponse> searchCriteria(SearchCriteriaRequest request, AsyncHandler<SearchCriteriaRequest, SearchCriteriaResponse> handler) {
        LOG.trace("Called async searchCriteria");
        SearchCriteriaRequest interceptedRequest = SearchCriteriaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchCriteriaConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, SearchCriteriaResponse> transformer = SearchCriteriaConverter.fromResponse();
        AsyncHandler<SearchCriteriaRequest, SearchCriteriaResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SearchCriteriaRequest, SearchCriteriaResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<TestConnectionResponse> testConnection(TestConnectionRequest request, AsyncHandler<TestConnectionRequest, TestConnectionResponse> handler) {
        LOG.trace("Called async testConnection");
        TestConnectionRequest interceptedRequest = TestConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TestConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, TestConnectionResponse> transformer = TestConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<TestConnectionRequest, TestConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<TestConnectionRequest, TestConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAttributeResponse> updateAttribute(UpdateAttributeRequest request, AsyncHandler<UpdateAttributeRequest, UpdateAttributeResponse> handler) {
        LOG.trace("Called async updateAttribute");
        UpdateAttributeRequest interceptedRequest = UpdateAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAttributeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateAttributeResponse> transformer = UpdateAttributeConverter.fromResponse();
        AsyncHandler<UpdateAttributeRequest, UpdateAttributeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAttributeRequest, UpdateAttributeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCatalogResponse> updateCatalog(UpdateCatalogRequest request, AsyncHandler<UpdateCatalogRequest, UpdateCatalogResponse> handler) {
        LOG.trace("Called async updateCatalog");
        UpdateCatalogRequest interceptedRequest = UpdateCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCatalogConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCatalogResponse> transformer = UpdateCatalogConverter.fromResponse();
        AsyncHandler<UpdateCatalogRequest, UpdateCatalogResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCatalogRequest, UpdateCatalogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCatalogPrivateEndpointResponse> updateCatalogPrivateEndpoint(UpdateCatalogPrivateEndpointRequest request, AsyncHandler<UpdateCatalogPrivateEndpointRequest, UpdateCatalogPrivateEndpointResponse> handler) {
        LOG.trace("Called async updateCatalogPrivateEndpoint");
        UpdateCatalogPrivateEndpointRequest interceptedRequest = UpdateCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCatalogPrivateEndpointResponse> transformer = UpdateCatalogPrivateEndpointConverter.fromResponse();
        AsyncHandler<UpdateCatalogPrivateEndpointRequest, UpdateCatalogPrivateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCatalogPrivateEndpointRequest, UpdateCatalogPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        LOG.trace("Called async updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConnectionRequest, UpdateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCustomPropertyResponse> updateCustomProperty(UpdateCustomPropertyRequest request, AsyncHandler<UpdateCustomPropertyRequest, UpdateCustomPropertyResponse> handler) {
        LOG.trace("Called async updateCustomProperty");
        UpdateCustomPropertyRequest interceptedRequest = UpdateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCustomPropertyResponse> transformer = UpdateCustomPropertyConverter.fromResponse();
        AsyncHandler<UpdateCustomPropertyRequest, UpdateCustomPropertyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCustomPropertyRequest, UpdateCustomPropertyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDataAssetResponse> updateDataAsset(UpdateDataAssetRequest request, AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handler) {
        LOG.trace("Called async updateDataAsset");
        UpdateDataAssetRequest interceptedRequest = UpdateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDataAssetResponse> transformer = UpdateDataAssetConverter.fromResponse();
        AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDataAssetRequest, UpdateDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateEntityResponse> updateEntity(UpdateEntityRequest request, AsyncHandler<UpdateEntityRequest, UpdateEntityResponse> handler) {
        LOG.trace("Called async updateEntity");
        UpdateEntityRequest interceptedRequest = UpdateEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateEntityResponse> transformer = UpdateEntityConverter.fromResponse();
        AsyncHandler<UpdateEntityRequest, UpdateEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateEntityRequest, UpdateEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateFolderResponse> updateFolder(UpdateFolderRequest request, AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handler) {
        LOG.trace("Called async updateFolder");
        UpdateFolderRequest interceptedRequest = UpdateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateFolderResponse> transformer = UpdateFolderConverter.fromResponse();
        AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateFolderRequest, UpdateFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateGlossaryResponse> updateGlossary(UpdateGlossaryRequest request, AsyncHandler<UpdateGlossaryRequest, UpdateGlossaryResponse> handler) {
        LOG.trace("Called async updateGlossary");
        UpdateGlossaryRequest interceptedRequest = UpdateGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGlossaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateGlossaryResponse> transformer = UpdateGlossaryConverter.fromResponse();
        AsyncHandler<UpdateGlossaryRequest, UpdateGlossaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateGlossaryRequest, UpdateGlossaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        LOG.trace("Called async updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        AsyncHandler<UpdateJobRequest, UpdateJobResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJobRequest, UpdateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJobDefinitionResponse> updateJobDefinition(UpdateJobDefinitionRequest request, AsyncHandler<UpdateJobDefinitionRequest, UpdateJobDefinitionResponse> handler) {
        LOG.trace("Called async updateJobDefinition");
        UpdateJobDefinitionRequest interceptedRequest = UpdateJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateJobDefinitionResponse> transformer = UpdateJobDefinitionConverter.fromResponse();
        AsyncHandler<UpdateJobDefinitionRequest, UpdateJobDefinitionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJobDefinitionRequest, UpdateJobDefinitionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNamespaceResponse> updateNamespace(UpdateNamespaceRequest request, AsyncHandler<UpdateNamespaceRequest, UpdateNamespaceResponse> handler) {
        LOG.trace("Called async updateNamespace");
        UpdateNamespaceRequest interceptedRequest = UpdateNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateNamespaceResponse> transformer = UpdateNamespaceConverter.fromResponse();
        AsyncHandler<UpdateNamespaceRequest, UpdateNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNamespaceRequest, UpdateNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePatternResponse> updatePattern(UpdatePatternRequest request, AsyncHandler<UpdatePatternRequest, UpdatePatternResponse> handler) {
        LOG.trace("Called async updatePattern");
        UpdatePatternRequest interceptedRequest = UpdatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePatternConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdatePatternResponse> transformer = UpdatePatternConverter.fromResponse();
        AsyncHandler<UpdatePatternRequest, UpdatePatternResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePatternRequest, UpdatePatternResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTermResponse> updateTerm(UpdateTermRequest request, AsyncHandler<UpdateTermRequest, UpdateTermResponse> handler) {
        LOG.trace("Called async updateTerm");
        UpdateTermRequest interceptedRequest = UpdateTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTermConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTermResponse> transformer = UpdateTermConverter.fromResponse();
        AsyncHandler<UpdateTermRequest, UpdateTermResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTermRequest, UpdateTermResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTermRelationshipResponse> updateTermRelationship(UpdateTermRelationshipRequest request, AsyncHandler<UpdateTermRelationshipRequest, UpdateTermRelationshipResponse> handler) {
        LOG.trace("Called async updateTermRelationship");
        UpdateTermRelationshipRequest interceptedRequest = UpdateTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTermRelationshipResponse> transformer = UpdateTermRelationshipConverter.fromResponse();
        AsyncHandler<UpdateTermRelationshipRequest, UpdateTermRelationshipResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTermRelationshipRequest, UpdateTermRelationshipResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UploadCredentialsResponse> uploadCredentials(UploadCredentialsRequest request, AsyncHandler<UploadCredentialsRequest, UploadCredentialsResponse> handler) {
        LOG.trace("Called async uploadCredentials");
        UploadCredentialsRequest interceptedRequest = UploadCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadCredentialsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UploadCredentialsResponse> transformer = UploadCredentialsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UploadCredentialsRequest, UploadCredentialsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UploadCredentialsRequest, UploadCredentialsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UsersResponse> users(UsersRequest request, AsyncHandler<UsersRequest, UsersResponse> handler) {
        LOG.trace("Called async users");
        UsersRequest interceptedRequest = UsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UsersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UsersResponse> transformer = UsersConverter.fromResponse();
        AsyncHandler<UsersRequest, UsersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UsersRequest, UsersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateConnectionResponse> validateConnection(ValidateConnectionRequest request, AsyncHandler<ValidateConnectionRequest, ValidateConnectionResponse> handler) {
        LOG.trace("Called async validateConnection");
        ValidateConnectionRequest interceptedRequest = ValidateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateConnectionResponse> transformer = ValidateConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ValidateConnectionRequest, ValidateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateConnectionRequest, ValidateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidatePatternResponse> validatePattern(ValidatePatternRequest request, AsyncHandler<ValidatePatternRequest, ValidatePatternResponse> handler) {
        LOG.trace("Called async validatePattern");
        ValidatePatternRequest interceptedRequest = ValidatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidatePatternConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidatePatternResponse> transformer = ValidatePatternConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ValidatePatternRequest, ValidatePatternResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidatePatternRequest, ValidatePatternResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataCatalogAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataCatalogAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataCatalogAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

