/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datacatalog.DataCatalog;
import com.oracle.bmc.datacatalog.DataCatalogPaginators;
import com.oracle.bmc.datacatalog.DataCatalogWaiters;
import com.oracle.bmc.datacatalog.internal.http.AddDataSelectorPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.AssociateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.AttachCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.ChangeCatalogCompartmentConverter;
import com.oracle.bmc.datacatalog.internal.http.ChangeCatalogPrivateEndpointCompartmentConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateJobExecutionConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.CreatePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateTermConverter;
import com.oracle.bmc.datacatalog.internal.http.CreateTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteJobConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.DeletePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteTermConverter;
import com.oracle.bmc.datacatalog.internal.http.DeleteTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.DetachCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.DisassociateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.ExpandTreeForGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.ExportGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.GetAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.GetAttributeTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.GetConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.GetDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.GetDataAssetTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.GetEntityTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.GetFolderTagConverter;
import com.oracle.bmc.datacatalog.internal.http.GetGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobExecutionConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobLogConverter;
import com.oracle.bmc.datacatalog.internal.http.GetJobMetricsConverter;
import com.oracle.bmc.datacatalog.internal.http.GetNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.GetPatternConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTermConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.GetTypeConverter;
import com.oracle.bmc.datacatalog.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datacatalog.internal.http.ImportConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ImportGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAggregatedPhysicalEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAttributeTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListAttributesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCatalogPrivateEndpointsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCatalogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListConnectionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListCustomPropertiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDataAssetTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDataAssetsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListDerivedLogicalEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListEntitiesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListEntityTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListFolderTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListFoldersConverter;
import com.oracle.bmc.datacatalog.internal.http.ListGlossariesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobDefinitionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobExecutionsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobLogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobMetricsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListJobsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListNamespacesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListRulesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTagsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTermRelationshipsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTermsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListTypesConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datacatalog.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datacatalog.internal.http.ObjectStatsConverter;
import com.oracle.bmc.datacatalog.internal.http.ParseConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ProcessRecommendationConverter;
import com.oracle.bmc.datacatalog.internal.http.RecommendationsConverter;
import com.oracle.bmc.datacatalog.internal.http.RemoveDataSelectorPatternsConverter;
import com.oracle.bmc.datacatalog.internal.http.SearchCriteriaConverter;
import com.oracle.bmc.datacatalog.internal.http.TestConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateAttributeConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCatalogConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCatalogPrivateEndpointConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateCustomPropertyConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateDataAssetConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateEntityConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateFolderConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateGlossaryConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateJobConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateJobDefinitionConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateNamespaceConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdatePatternConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateTermConverter;
import com.oracle.bmc.datacatalog.internal.http.UpdateTermRelationshipConverter;
import com.oracle.bmc.datacatalog.internal.http.UploadCredentialsConverter;
import com.oracle.bmc.datacatalog.internal.http.UsersConverter;
import com.oracle.bmc.datacatalog.internal.http.ValidateConnectionConverter;
import com.oracle.bmc.datacatalog.internal.http.ValidatePatternConverter;
import com.oracle.bmc.datacatalog.requests.AddDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.AssociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.AttachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogPrivateEndpointCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.CreateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.CreateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobRequest;
import com.oracle.bmc.datacatalog.requests.CreateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.CreatePatternRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogRequest;
import com.oracle.bmc.datacatalog.requests.DeleteConnectionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobRequest;
import com.oracle.bmc.datacatalog.requests.DeleteNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.DeletePatternRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRequest;
import com.oracle.bmc.datacatalog.requests.DetachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DisassociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.ExpandTreeForGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ExportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogRequest;
import com.oracle.bmc.datacatalog.requests.GetConnectionRequest;
import com.oracle.bmc.datacatalog.requests.GetCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.GetGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobLogRequest;
import com.oracle.bmc.datacatalog.requests.GetJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.GetJobRequest;
import com.oracle.bmc.datacatalog.requests.GetNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.GetPatternRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRequest;
import com.oracle.bmc.datacatalog.requests.GetTypeRequest;
import com.oracle.bmc.datacatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.datacatalog.requests.ImportConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ImportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ListAggregatedPhysicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributeTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributesRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogPrivateEndpointsRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogsRequest;
import com.oracle.bmc.datacatalog.requests.ListConnectionsRequest;
import com.oracle.bmc.datacatalog.requests.ListCustomPropertiesRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetsRequest;
import com.oracle.bmc.datacatalog.requests.ListDerivedLogicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntityTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFolderTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFoldersRequest;
import com.oracle.bmc.datacatalog.requests.ListGlossariesRequest;
import com.oracle.bmc.datacatalog.requests.ListJobDefinitionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobExecutionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobsRequest;
import com.oracle.bmc.datacatalog.requests.ListNamespacesRequest;
import com.oracle.bmc.datacatalog.requests.ListPatternsRequest;
import com.oracle.bmc.datacatalog.requests.ListRulesRequest;
import com.oracle.bmc.datacatalog.requests.ListTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermRelationshipsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermsRequest;
import com.oracle.bmc.datacatalog.requests.ListTypesRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datacatalog.requests.ObjectStatsRequest;
import com.oracle.bmc.datacatalog.requests.ParseConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ProcessRecommendationRequest;
import com.oracle.bmc.datacatalog.requests.RecommendationsRequest;
import com.oracle.bmc.datacatalog.requests.RemoveDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.SearchCriteriaRequest;
import com.oracle.bmc.datacatalog.requests.TestConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.UpdateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.UpdateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.UpdateEntityRequest;
import com.oracle.bmc.datacatalog.requests.UpdateFolderRequest;
import com.oracle.bmc.datacatalog.requests.UpdateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobRequest;
import com.oracle.bmc.datacatalog.requests.UpdateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.UpdatePatternRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRequest;
import com.oracle.bmc.datacatalog.requests.UploadCredentialsRequest;
import com.oracle.bmc.datacatalog.requests.UsersRequest;
import com.oracle.bmc.datacatalog.requests.ValidateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ValidatePatternRequest;
import com.oracle.bmc.datacatalog.responses.AddDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.AssociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.AttachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogPrivateEndpointCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.CreateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.CreateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobResponse;
import com.oracle.bmc.datacatalog.responses.CreateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.CreatePatternResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogResponse;
import com.oracle.bmc.datacatalog.responses.DeleteConnectionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobResponse;
import com.oracle.bmc.datacatalog.responses.DeleteNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.DeletePatternResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermResponse;
import com.oracle.bmc.datacatalog.responses.DetachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DisassociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.ExpandTreeForGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ExportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogResponse;
import com.oracle.bmc.datacatalog.responses.GetConnectionResponse;
import com.oracle.bmc.datacatalog.responses.GetCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.GetGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobLogResponse;
import com.oracle.bmc.datacatalog.responses.GetJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.GetJobResponse;
import com.oracle.bmc.datacatalog.responses.GetNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.GetPatternResponse;
import com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.GetTermResponse;
import com.oracle.bmc.datacatalog.responses.GetTypeResponse;
import com.oracle.bmc.datacatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.datacatalog.responses.ImportConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ImportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ListAggregatedPhysicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributeTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributesResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogPrivateEndpointsResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogsResponse;
import com.oracle.bmc.datacatalog.responses.ListConnectionsResponse;
import com.oracle.bmc.datacatalog.responses.ListCustomPropertiesResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetsResponse;
import com.oracle.bmc.datacatalog.responses.ListDerivedLogicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntityTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFolderTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFoldersResponse;
import com.oracle.bmc.datacatalog.responses.ListGlossariesResponse;
import com.oracle.bmc.datacatalog.responses.ListJobDefinitionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobExecutionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobsResponse;
import com.oracle.bmc.datacatalog.responses.ListNamespacesResponse;
import com.oracle.bmc.datacatalog.responses.ListPatternsResponse;
import com.oracle.bmc.datacatalog.responses.ListRulesResponse;
import com.oracle.bmc.datacatalog.responses.ListTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermRelationshipsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermsResponse;
import com.oracle.bmc.datacatalog.responses.ListTypesResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datacatalog.responses.ObjectStatsResponse;
import com.oracle.bmc.datacatalog.responses.ParseConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ProcessRecommendationResponse;
import com.oracle.bmc.datacatalog.responses.RecommendationsResponse;
import com.oracle.bmc.datacatalog.responses.RemoveDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.SearchCriteriaResponse;
import com.oracle.bmc.datacatalog.responses.TestConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.UpdateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.UpdateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.UpdateEntityResponse;
import com.oracle.bmc.datacatalog.responses.UpdateFolderResponse;
import com.oracle.bmc.datacatalog.responses.UpdateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobResponse;
import com.oracle.bmc.datacatalog.responses.UpdateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.UpdatePatternResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermResponse;
import com.oracle.bmc.datacatalog.responses.UploadCredentialsResponse;
import com.oracle.bmc.datacatalog.responses.UsersResponse;
import com.oracle.bmc.datacatalog.responses.ValidateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ValidatePatternResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogClient
implements DataCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATACATALOG").serviceEndpointPrefix("").serviceEndpointTemplate("https://datacatalog.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DataCatalogWaiters waiters;
    private final DataCatalogPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataCatalog-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataCatalogWaiters(executorService, this);
        this.paginators = new DataCatalogPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddDataSelectorPatternsResponse addDataSelectorPatterns(AddDataSelectorPatternsRequest request) {
        LOG.trace("Called addDataSelectorPatterns");
        AddDataSelectorPatternsRequest interceptedRequest = AddDataSelectorPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddDataSelectorPatternsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddDataSelectorPatternsResponse> transformer = AddDataSelectorPatternsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddDataSelectorPatternsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddDataSelectorPatternsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDataSelectorPatternDetails(), (BmcRequest)retriedRequest);
                return (AddDataSelectorPatternsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AssociateCustomPropertyResponse associateCustomProperty(AssociateCustomPropertyRequest request) {
        LOG.trace("Called associateCustomProperty");
        AssociateCustomPropertyRequest interceptedRequest = AssociateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AssociateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AssociateCustomPropertyResponse> transformer = AssociateCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AssociateCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AssociateCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAssociateCustomPropertyDetails(), (BmcRequest)retriedRequest);
                return (AssociateCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AttachCatalogPrivateEndpointResponse attachCatalogPrivateEndpoint(AttachCatalogPrivateEndpointRequest request) {
        LOG.trace("Called attachCatalogPrivateEndpoint");
        AttachCatalogPrivateEndpointRequest interceptedRequest = AttachCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachCatalogPrivateEndpointResponse> transformer = AttachCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AttachCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachCatalogPrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (AttachCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCatalogCompartmentResponse changeCatalogCompartment(ChangeCatalogCompartmentRequest request) {
        LOG.trace("Called changeCatalogCompartment");
        ChangeCatalogCompartmentRequest interceptedRequest = ChangeCatalogCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCatalogCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCatalogCompartmentResponse> transformer = ChangeCatalogCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeCatalogCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCatalogCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCatalogCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCatalogCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCatalogPrivateEndpointCompartmentResponse changeCatalogPrivateEndpointCompartment(ChangeCatalogPrivateEndpointCompartmentRequest request) {
        LOG.trace("Called changeCatalogPrivateEndpointCompartment");
        ChangeCatalogPrivateEndpointCompartmentRequest interceptedRequest = ChangeCatalogPrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCatalogPrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCatalogPrivateEndpointCompartmentResponse> transformer = ChangeCatalogPrivateEndpointCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeCatalogPrivateEndpointCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCatalogPrivateEndpointCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCatalogPrivateEndpointCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCatalogPrivateEndpointCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAttributeResponse createAttribute(CreateAttributeRequest request) {
        LOG.trace("Called createAttribute");
        CreateAttributeRequest interceptedRequest = CreateAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAttributeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAttributeResponse> transformer = CreateAttributeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAttributeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAttributeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAttributeDetails(), (BmcRequest)retriedRequest);
                return (CreateAttributeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAttributeTagResponse createAttributeTag(CreateAttributeTagRequest request) {
        LOG.trace("Called createAttributeTag");
        CreateAttributeTagRequest interceptedRequest = CreateAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAttributeTagResponse> transformer = CreateAttributeTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAttributeTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAttributeTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAttributeTagDetails(), (BmcRequest)retriedRequest);
                return (CreateAttributeTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCatalogResponse createCatalog(CreateCatalogRequest request) {
        LOG.trace("Called createCatalog");
        CreateCatalogRequest interceptedRequest = CreateCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCatalogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCatalogResponse> transformer = CreateCatalogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCatalogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCatalogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCatalogDetails(), (BmcRequest)retriedRequest);
                return (CreateCatalogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCatalogPrivateEndpointResponse createCatalogPrivateEndpoint(CreateCatalogPrivateEndpointRequest request) {
        LOG.trace("Called createCatalogPrivateEndpoint");
        CreateCatalogPrivateEndpointRequest interceptedRequest = CreateCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCatalogPrivateEndpointResponse> transformer = CreateCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCatalogPrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (CreateCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        LOG.trace("Called createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectionDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCustomPropertyResponse createCustomProperty(CreateCustomPropertyRequest request) {
        LOG.trace("Called createCustomProperty");
        CreateCustomPropertyRequest interceptedRequest = CreateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCustomPropertyResponse> transformer = CreateCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCustomPropertyDetails(), (BmcRequest)retriedRequest);
                return (CreateCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataAssetResponse createDataAsset(CreateDataAssetRequest request) {
        LOG.trace("Called createDataAsset");
        CreateDataAssetRequest interceptedRequest = CreateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataAssetResponse> transformer = CreateDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataAssetDetails(), (BmcRequest)retriedRequest);
                return (CreateDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataAssetTagResponse createDataAssetTag(CreateDataAssetTagRequest request) {
        LOG.trace("Called createDataAssetTag");
        CreateDataAssetTagRequest interceptedRequest = CreateDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataAssetTagResponse> transformer = CreateDataAssetTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataAssetTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataAssetTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataAssetTagDetails(), (BmcRequest)retriedRequest);
                return (CreateDataAssetTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateEntityResponse createEntity(CreateEntityRequest request) {
        LOG.trace("Called createEntity");
        CreateEntityRequest interceptedRequest = CreateEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateEntityResponse> transformer = CreateEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateEntityDetails(), (BmcRequest)retriedRequest);
                return (CreateEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateEntityTagResponse createEntityTag(CreateEntityTagRequest request) {
        LOG.trace("Called createEntityTag");
        CreateEntityTagRequest interceptedRequest = CreateEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateEntityTagResponse> transformer = CreateEntityTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateEntityTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateEntityTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateEntityTagDetails(), (BmcRequest)retriedRequest);
                return (CreateEntityTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest request) {
        LOG.trace("Called createFolder");
        CreateFolderRequest interceptedRequest = CreateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFolderResponse> transformer = CreateFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateFolderDetails(), (BmcRequest)retriedRequest);
                return (CreateFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateFolderTagResponse createFolderTag(CreateFolderTagRequest request) {
        LOG.trace("Called createFolderTag");
        CreateFolderTagRequest interceptedRequest = CreateFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFolderTagResponse> transformer = CreateFolderTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateFolderTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateFolderTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateFolderTagDetails(), (BmcRequest)retriedRequest);
                return (CreateFolderTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateGlossaryResponse createGlossary(CreateGlossaryRequest request) {
        LOG.trace("Called createGlossary");
        CreateGlossaryRequest interceptedRequest = CreateGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateGlossaryResponse> transformer = CreateGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateGlossaryDetails(), (BmcRequest)retriedRequest);
                return (CreateGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDetails(), (BmcRequest)retriedRequest);
                return (CreateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobDefinitionResponse createJobDefinition(CreateJobDefinitionRequest request) {
        LOG.trace("Called createJobDefinition");
        CreateJobDefinitionRequest interceptedRequest = CreateJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobDefinitionResponse> transformer = CreateJobDefinitionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateJobDefinitionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobDefinitionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDefinitionDetails(), (BmcRequest)retriedRequest);
                return (CreateJobDefinitionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobExecutionResponse createJobExecution(CreateJobExecutionRequest request) {
        LOG.trace("Called createJobExecution");
        CreateJobExecutionRequest interceptedRequest = CreateJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobExecutionResponse> transformer = CreateJobExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateJobExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobExecutionDetails(), (BmcRequest)retriedRequest);
                return (CreateJobExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        LOG.trace("Called createNamespace");
        CreateNamespaceRequest interceptedRequest = CreateNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNamespaceResponse> transformer = CreateNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateNamespaceDetails(), (BmcRequest)retriedRequest);
                return (CreateNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePatternResponse createPattern(CreatePatternRequest request) {
        LOG.trace("Called createPattern");
        CreatePatternRequest interceptedRequest = CreatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePatternConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePatternResponse> transformer = CreatePatternConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePatternResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePatternResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePatternDetails(), (BmcRequest)retriedRequest);
                return (CreatePatternResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTermResponse createTerm(CreateTermRequest request) {
        LOG.trace("Called createTerm");
        CreateTermRequest interceptedRequest = CreateTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTermConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTermResponse> transformer = CreateTermConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTermResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTermResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTermDetails(), (BmcRequest)retriedRequest);
                return (CreateTermResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTermRelationshipResponse createTermRelationship(CreateTermRelationshipRequest request) {
        LOG.trace("Called createTermRelationship");
        CreateTermRelationshipRequest interceptedRequest = CreateTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTermRelationshipResponse> transformer = CreateTermRelationshipConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTermRelationshipResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTermRelationshipResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTermRelationshipDetails(), (BmcRequest)retriedRequest);
                return (CreateTermRelationshipResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAttributeResponse deleteAttribute(DeleteAttributeRequest request) {
        LOG.trace("Called deleteAttribute");
        DeleteAttributeRequest interceptedRequest = DeleteAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAttributeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAttributeResponse> transformer = DeleteAttributeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAttributeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAttributeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAttributeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAttributeTagResponse deleteAttributeTag(DeleteAttributeTagRequest request) {
        LOG.trace("Called deleteAttributeTag");
        DeleteAttributeTagRequest interceptedRequest = DeleteAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAttributeTagResponse> transformer = DeleteAttributeTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAttributeTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAttributeTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAttributeTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCatalogResponse deleteCatalog(DeleteCatalogRequest request) {
        LOG.trace("Called deleteCatalog");
        DeleteCatalogRequest interceptedRequest = DeleteCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCatalogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCatalogResponse> transformer = DeleteCatalogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCatalogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCatalogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCatalogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCatalogPrivateEndpointResponse deleteCatalogPrivateEndpoint(DeleteCatalogPrivateEndpointRequest request) {
        LOG.trace("Called deleteCatalogPrivateEndpoint");
        DeleteCatalogPrivateEndpointRequest interceptedRequest = DeleteCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCatalogPrivateEndpointResponse> transformer = DeleteCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        LOG.trace("Called deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCustomPropertyResponse deleteCustomProperty(DeleteCustomPropertyRequest request) {
        LOG.trace("Called deleteCustomProperty");
        DeleteCustomPropertyRequest interceptedRequest = DeleteCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCustomPropertyResponse> transformer = DeleteCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataAssetResponse deleteDataAsset(DeleteDataAssetRequest request) {
        LOG.trace("Called deleteDataAsset");
        DeleteDataAssetRequest interceptedRequest = DeleteDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataAssetResponse> transformer = DeleteDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataAssetTagResponse deleteDataAssetTag(DeleteDataAssetTagRequest request) {
        LOG.trace("Called deleteDataAssetTag");
        DeleteDataAssetTagRequest interceptedRequest = DeleteDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataAssetTagResponse> transformer = DeleteDataAssetTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataAssetTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataAssetTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataAssetTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteEntityResponse deleteEntity(DeleteEntityRequest request) {
        LOG.trace("Called deleteEntity");
        DeleteEntityRequest interceptedRequest = DeleteEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteEntityResponse> transformer = DeleteEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteEntityTagResponse deleteEntityTag(DeleteEntityTagRequest request) {
        LOG.trace("Called deleteEntityTag");
        DeleteEntityTagRequest interceptedRequest = DeleteEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEntityTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteEntityTagResponse> transformer = DeleteEntityTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteEntityTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteEntityTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteEntityTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) {
        LOG.trace("Called deleteFolder");
        DeleteFolderRequest interceptedRequest = DeleteFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFolderResponse> transformer = DeleteFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFolderTagResponse deleteFolderTag(DeleteFolderTagRequest request) {
        LOG.trace("Called deleteFolderTag");
        DeleteFolderTagRequest interceptedRequest = DeleteFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFolderTagResponse> transformer = DeleteFolderTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteFolderTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteFolderTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteFolderTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteGlossaryResponse deleteGlossary(DeleteGlossaryRequest request) {
        LOG.trace("Called deleteGlossary");
        DeleteGlossaryRequest interceptedRequest = DeleteGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteGlossaryResponse> transformer = DeleteGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        LOG.trace("Called deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteJobDefinitionResponse deleteJobDefinition(DeleteJobDefinitionRequest request) {
        LOG.trace("Called deleteJobDefinition");
        DeleteJobDefinitionRequest interceptedRequest = DeleteJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobDefinitionResponse> transformer = DeleteJobDefinitionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteJobDefinitionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobDefinitionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobDefinitionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest request) {
        LOG.trace("Called deleteNamespace");
        DeleteNamespaceRequest interceptedRequest = DeleteNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNamespaceResponse> transformer = DeleteNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePatternResponse deletePattern(DeletePatternRequest request) {
        LOG.trace("Called deletePattern");
        DeletePatternRequest interceptedRequest = DeletePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePatternConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePatternResponse> transformer = DeletePatternConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePatternResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePatternResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePatternResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTermResponse deleteTerm(DeleteTermRequest request) {
        LOG.trace("Called deleteTerm");
        DeleteTermRequest interceptedRequest = DeleteTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTermConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTermResponse> transformer = DeleteTermConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTermResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTermResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTermResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTermRelationshipResponse deleteTermRelationship(DeleteTermRelationshipRequest request) {
        LOG.trace("Called deleteTermRelationship");
        DeleteTermRelationshipRequest interceptedRequest = DeleteTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTermRelationshipResponse> transformer = DeleteTermRelationshipConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTermRelationshipResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTermRelationshipResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTermRelationshipResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachCatalogPrivateEndpointResponse detachCatalogPrivateEndpoint(DetachCatalogPrivateEndpointRequest request) {
        LOG.trace("Called detachCatalogPrivateEndpoint");
        DetachCatalogPrivateEndpointRequest interceptedRequest = DetachCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachCatalogPrivateEndpointResponse> transformer = DetachCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DetachCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachCatalogPrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (DetachCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DisassociateCustomPropertyResponse disassociateCustomProperty(DisassociateCustomPropertyRequest request) {
        LOG.trace("Called disassociateCustomProperty");
        DisassociateCustomPropertyRequest interceptedRequest = DisassociateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisassociateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DisassociateCustomPropertyResponse> transformer = DisassociateCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DisassociateCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DisassociateCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDisassociateCustomPropertyDetails(), (BmcRequest)retriedRequest);
                return (DisassociateCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExpandTreeForGlossaryResponse expandTreeForGlossary(ExpandTreeForGlossaryRequest request) {
        LOG.trace("Called expandTreeForGlossary");
        ExpandTreeForGlossaryRequest interceptedRequest = ExpandTreeForGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExpandTreeForGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExpandTreeForGlossaryResponse> transformer = ExpandTreeForGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExpandTreeForGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExpandTreeForGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ExpandTreeForGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExportGlossaryResponse exportGlossary(ExportGlossaryRequest request) {
        LOG.trace("Called exportGlossary");
        ExportGlossaryRequest interceptedRequest = ExportGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportGlossaryResponse> transformer = ExportGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExportGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExportGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ExportGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAttributeResponse getAttribute(GetAttributeRequest request) {
        LOG.trace("Called getAttribute");
        GetAttributeRequest interceptedRequest = GetAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAttributeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAttributeResponse> transformer = GetAttributeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAttributeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAttributeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAttributeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAttributeTagResponse getAttributeTag(GetAttributeTagRequest request) {
        LOG.trace("Called getAttributeTag");
        GetAttributeTagRequest interceptedRequest = GetAttributeTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAttributeTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAttributeTagResponse> transformer = GetAttributeTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAttributeTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAttributeTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAttributeTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCatalogResponse getCatalog(GetCatalogRequest request) {
        LOG.trace("Called getCatalog");
        GetCatalogRequest interceptedRequest = GetCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCatalogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCatalogResponse> transformer = GetCatalogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCatalogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCatalogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCatalogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCatalogPrivateEndpointResponse getCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request) {
        LOG.trace("Called getCatalogPrivateEndpoint");
        GetCatalogPrivateEndpointRequest interceptedRequest = GetCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCatalogPrivateEndpointResponse> transformer = GetCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        LOG.trace("Called getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCustomPropertyResponse getCustomProperty(GetCustomPropertyRequest request) {
        LOG.trace("Called getCustomProperty");
        GetCustomPropertyRequest interceptedRequest = GetCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCustomPropertyResponse> transformer = GetCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataAssetResponse getDataAsset(GetDataAssetRequest request) {
        LOG.trace("Called getDataAsset");
        GetDataAssetRequest interceptedRequest = GetDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataAssetResponse> transformer = GetDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataAssetTagResponse getDataAssetTag(GetDataAssetTagRequest request) {
        LOG.trace("Called getDataAssetTag");
        GetDataAssetTagRequest interceptedRequest = GetDataAssetTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataAssetTagResponse> transformer = GetDataAssetTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataAssetTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataAssetTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataAssetTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetEntityResponse getEntity(GetEntityRequest request) {
        LOG.trace("Called getEntity");
        GetEntityRequest interceptedRequest = GetEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetEntityResponse> transformer = GetEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetEntityTagResponse getEntityTag(GetEntityTagRequest request) {
        LOG.trace("Called getEntityTag");
        GetEntityTagRequest interceptedRequest = GetEntityTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEntityTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetEntityTagResponse> transformer = GetEntityTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetEntityTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEntityTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEntityTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest request) {
        LOG.trace("Called getFolder");
        GetFolderRequest interceptedRequest = GetFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFolderResponse> transformer = GetFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFolderTagResponse getFolderTag(GetFolderTagRequest request) {
        LOG.trace("Called getFolderTag");
        GetFolderTagRequest interceptedRequest = GetFolderTagConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderTagConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFolderTagResponse> transformer = GetFolderTagConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetFolderTagResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFolderTagResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFolderTagResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetGlossaryResponse getGlossary(GetGlossaryRequest request) {
        LOG.trace("Called getGlossary");
        GetGlossaryRequest interceptedRequest = GetGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetGlossaryResponse> transformer = GetGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobDefinitionResponse getJobDefinition(GetJobDefinitionRequest request) {
        LOG.trace("Called getJobDefinition");
        GetJobDefinitionRequest interceptedRequest = GetJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobDefinitionResponse> transformer = GetJobDefinitionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobDefinitionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobDefinitionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobDefinitionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobExecutionResponse getJobExecution(GetJobExecutionRequest request) {
        LOG.trace("Called getJobExecution");
        GetJobExecutionRequest interceptedRequest = GetJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobExecutionResponse> transformer = GetJobExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobLogResponse getJobLog(GetJobLogRequest request) {
        LOG.trace("Called getJobLog");
        GetJobLogRequest interceptedRequest = GetJobLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogResponse> transformer = GetJobLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobMetricsResponse getJobMetrics(GetJobMetricsRequest request) {
        LOG.trace("Called getJobMetrics");
        GetJobMetricsRequest interceptedRequest = GetJobMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobMetricsResponse> transformer = GetJobMetricsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobMetricsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobMetricsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobMetricsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        LOG.trace("Called getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPatternResponse getPattern(GetPatternRequest request) {
        LOG.trace("Called getPattern");
        GetPatternRequest interceptedRequest = GetPatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPatternConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPatternResponse> transformer = GetPatternConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPatternResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPatternResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPatternResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTermResponse getTerm(GetTermRequest request) {
        LOG.trace("Called getTerm");
        GetTermRequest interceptedRequest = GetTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTermConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTermResponse> transformer = GetTermConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTermResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTermResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTermResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTermRelationshipResponse getTermRelationship(GetTermRelationshipRequest request) {
        LOG.trace("Called getTermRelationship");
        GetTermRelationshipRequest interceptedRequest = GetTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTermRelationshipResponse> transformer = GetTermRelationshipConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTermRelationshipResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTermRelationshipResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTermRelationshipResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTypeResponse getType(GetTypeRequest request) {
        LOG.trace("Called getType");
        GetTypeRequest interceptedRequest = GetTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTypeResponse> transformer = GetTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ImportConnectionResponse importConnection(ImportConnectionRequest request) {
        LOG.trace("Called importConnection");
        ImportConnectionRequest interceptedRequest = ImportConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportConnectionResponse> transformer = ImportConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ImportConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ImportConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getImportConnectionDetails(), (BmcRequest)retriedRequest);
                return (ImportConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ImportGlossaryResponse importGlossary(ImportGlossaryRequest request) {
        LOG.trace("Called importGlossary");
        ImportGlossaryRequest interceptedRequest = ImportGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportGlossaryResponse> transformer = ImportGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ImportGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ImportGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getImportGlossaryDetails(), (BmcRequest)retriedRequest);
                return (ImportGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAggregatedPhysicalEntitiesResponse listAggregatedPhysicalEntities(ListAggregatedPhysicalEntitiesRequest request) {
        LOG.trace("Called listAggregatedPhysicalEntities");
        ListAggregatedPhysicalEntitiesRequest interceptedRequest = ListAggregatedPhysicalEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAggregatedPhysicalEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAggregatedPhysicalEntitiesResponse> transformer = ListAggregatedPhysicalEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAggregatedPhysicalEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAggregatedPhysicalEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ListAggregatedPhysicalEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAttributeTagsResponse listAttributeTags(ListAttributeTagsRequest request) {
        LOG.trace("Called listAttributeTags");
        ListAttributeTagsRequest interceptedRequest = ListAttributeTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAttributeTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAttributeTagsResponse> transformer = ListAttributeTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAttributeTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAttributeTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAttributeTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAttributesResponse listAttributes(ListAttributesRequest request) {
        LOG.trace("Called listAttributes");
        ListAttributesRequest interceptedRequest = ListAttributesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAttributesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAttributesResponse> transformer = ListAttributesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAttributesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAttributesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAttributesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCatalogPrivateEndpointsResponse listCatalogPrivateEndpoints(ListCatalogPrivateEndpointsRequest request) {
        LOG.trace("Called listCatalogPrivateEndpoints");
        ListCatalogPrivateEndpointsRequest interceptedRequest = ListCatalogPrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCatalogPrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCatalogPrivateEndpointsResponse> transformer = ListCatalogPrivateEndpointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCatalogPrivateEndpointsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCatalogPrivateEndpointsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCatalogPrivateEndpointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCatalogsResponse listCatalogs(ListCatalogsRequest request) {
        LOG.trace("Called listCatalogs");
        ListCatalogsRequest interceptedRequest = ListCatalogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCatalogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCatalogsResponse> transformer = ListCatalogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCatalogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCatalogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCatalogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        LOG.trace("Called listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConnectionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCustomPropertiesResponse listCustomProperties(ListCustomPropertiesRequest request) {
        LOG.trace("Called listCustomProperties");
        ListCustomPropertiesRequest interceptedRequest = ListCustomPropertiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomPropertiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCustomPropertiesResponse> transformer = ListCustomPropertiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCustomPropertiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCustomPropertiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCustomPropertiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataAssetTagsResponse listDataAssetTags(ListDataAssetTagsRequest request) {
        LOG.trace("Called listDataAssetTags");
        ListDataAssetTagsRequest interceptedRequest = ListDataAssetTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataAssetTagsResponse> transformer = ListDataAssetTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataAssetTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataAssetTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataAssetTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataAssetsResponse listDataAssets(ListDataAssetsRequest request) {
        LOG.trace("Called listDataAssets");
        ListDataAssetsRequest interceptedRequest = ListDataAssetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataAssetsResponse> transformer = ListDataAssetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataAssetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataAssetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataAssetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDerivedLogicalEntitiesResponse listDerivedLogicalEntities(ListDerivedLogicalEntitiesRequest request) {
        LOG.trace("Called listDerivedLogicalEntities");
        ListDerivedLogicalEntitiesRequest interceptedRequest = ListDerivedLogicalEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDerivedLogicalEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDerivedLogicalEntitiesResponse> transformer = ListDerivedLogicalEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ListDerivedLogicalEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDerivedLogicalEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ListDerivedLogicalEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEntitiesResponse listEntities(ListEntitiesRequest request) {
        LOG.trace("Called listEntities");
        ListEntitiesRequest interceptedRequest = ListEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEntitiesResponse> transformer = ListEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEntityTagsResponse listEntityTags(ListEntityTagsRequest request) {
        LOG.trace("Called listEntityTags");
        ListEntityTagsRequest interceptedRequest = ListEntityTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntityTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEntityTagsResponse> transformer = ListEntityTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEntityTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEntityTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEntityTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFolderTagsResponse listFolderTags(ListFolderTagsRequest request) {
        LOG.trace("Called listFolderTags");
        ListFolderTagsRequest interceptedRequest = ListFolderTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFolderTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFolderTagsResponse> transformer = ListFolderTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListFolderTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFolderTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFolderTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFoldersResponse listFolders(ListFoldersRequest request) {
        LOG.trace("Called listFolders");
        ListFoldersRequest interceptedRequest = ListFoldersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFoldersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFoldersResponse> transformer = ListFoldersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListFoldersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFoldersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFoldersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListGlossariesResponse listGlossaries(ListGlossariesRequest request) {
        LOG.trace("Called listGlossaries");
        ListGlossariesRequest interceptedRequest = ListGlossariesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGlossariesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListGlossariesResponse> transformer = ListGlossariesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListGlossariesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListGlossariesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListGlossariesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobDefinitionsResponse listJobDefinitions(ListJobDefinitionsRequest request) {
        LOG.trace("Called listJobDefinitions");
        ListJobDefinitionsRequest interceptedRequest = ListJobDefinitionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobDefinitionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobDefinitionsResponse> transformer = ListJobDefinitionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobDefinitionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobDefinitionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobDefinitionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobExecutionsResponse listJobExecutions(ListJobExecutionsRequest request) {
        LOG.trace("Called listJobExecutions");
        ListJobExecutionsRequest interceptedRequest = ListJobExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobExecutionsResponse> transformer = ListJobExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobLogsResponse listJobLogs(ListJobLogsRequest request) {
        LOG.trace("Called listJobLogs");
        ListJobLogsRequest interceptedRequest = ListJobLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobLogsResponse> transformer = ListJobLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobMetricsResponse listJobMetrics(ListJobMetricsRequest request) {
        LOG.trace("Called listJobMetrics");
        ListJobMetricsRequest interceptedRequest = ListJobMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobMetricsResponse> transformer = ListJobMetricsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobMetricsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobMetricsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobMetricsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        LOG.trace("Called listNamespaces");
        ListNamespacesRequest interceptedRequest = ListNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNamespacesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNamespacesResponse> transformer = ListNamespacesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNamespacesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNamespacesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNamespacesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPatternsResponse listPatterns(ListPatternsRequest request) {
        LOG.trace("Called listPatterns");
        ListPatternsRequest interceptedRequest = ListPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatternsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPatternsResponse> transformer = ListPatternsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPatternsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPatternsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPatternsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest request) {
        LOG.trace("Called listRules");
        ListRulesRequest interceptedRequest = ListRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRulesResponse> transformer = ListRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest request) {
        LOG.trace("Called listTags");
        ListTagsRequest interceptedRequest = ListTagsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTagsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTagsResponse> transformer = ListTagsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTagsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTagsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTagsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTermRelationshipsResponse listTermRelationships(ListTermRelationshipsRequest request) {
        LOG.trace("Called listTermRelationships");
        ListTermRelationshipsRequest interceptedRequest = ListTermRelationshipsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTermRelationshipsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTermRelationshipsResponse> transformer = ListTermRelationshipsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTermRelationshipsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTermRelationshipsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTermRelationshipsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTermsResponse listTerms(ListTermsRequest request) {
        LOG.trace("Called listTerms");
        ListTermsRequest interceptedRequest = ListTermsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTermsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTermsResponse> transformer = ListTermsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTermsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTermsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTermsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTypesResponse listTypes(ListTypesRequest request) {
        LOG.trace("Called listTypes");
        ListTypesRequest interceptedRequest = ListTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTypesResponse> transformer = ListTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ObjectStatsResponse objectStats(ObjectStatsRequest request) {
        LOG.trace("Called objectStats");
        ObjectStatsRequest interceptedRequest = ObjectStatsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ObjectStatsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ObjectStatsResponse> transformer = ObjectStatsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ObjectStatsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ObjectStatsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ObjectStatsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ParseConnectionResponse parseConnection(ParseConnectionRequest request) {
        LOG.trace("Called parseConnection");
        ParseConnectionRequest interceptedRequest = ParseConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ParseConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ParseConnectionResponse> transformer = ParseConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ParseConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ParseConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getParseConnectionDetails(), (BmcRequest)retriedRequest);
                return (ParseConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ProcessRecommendationResponse processRecommendation(ProcessRecommendationRequest request) {
        LOG.trace("Called processRecommendation");
        ProcessRecommendationRequest interceptedRequest = ProcessRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ProcessRecommendationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ProcessRecommendationResponse> transformer = ProcessRecommendationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ProcessRecommendationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ProcessRecommendationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getProcessRecommendationDetails(), (BmcRequest)retriedRequest);
                return (ProcessRecommendationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RecommendationsResponse recommendations(RecommendationsRequest request) {
        LOG.trace("Called recommendations");
        RecommendationsRequest interceptedRequest = RecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RecommendationsResponse> transformer = RecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveDataSelectorPatternsResponse removeDataSelectorPatterns(RemoveDataSelectorPatternsRequest request) {
        LOG.trace("Called removeDataSelectorPatterns");
        RemoveDataSelectorPatternsRequest interceptedRequest = RemoveDataSelectorPatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveDataSelectorPatternsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveDataSelectorPatternsResponse> transformer = RemoveDataSelectorPatternsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveDataSelectorPatternsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveDataSelectorPatternsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDataSelectorPatternDetails(), (BmcRequest)retriedRequest);
                return (RemoveDataSelectorPatternsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SearchCriteriaResponse searchCriteria(SearchCriteriaRequest request) {
        LOG.trace("Called searchCriteria");
        SearchCriteriaRequest interceptedRequest = SearchCriteriaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchCriteriaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SearchCriteriaResponse> transformer = SearchCriteriaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SearchCriteriaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SearchCriteriaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getSearchCriteriaDetails(), (BmcRequest)retriedRequest);
                return (SearchCriteriaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TestConnectionResponse testConnection(TestConnectionRequest request) {
        LOG.trace("Called testConnection");
        TestConnectionRequest interceptedRequest = TestConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TestConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TestConnectionResponse> transformer = TestConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (TestConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (TestConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (TestConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAttributeResponse updateAttribute(UpdateAttributeRequest request) {
        LOG.trace("Called updateAttribute");
        UpdateAttributeRequest interceptedRequest = UpdateAttributeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAttributeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAttributeResponse> transformer = UpdateAttributeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAttributeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAttributeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAttributeDetails(), (BmcRequest)retriedRequest);
                return (UpdateAttributeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCatalogResponse updateCatalog(UpdateCatalogRequest request) {
        LOG.trace("Called updateCatalog");
        UpdateCatalogRequest interceptedRequest = UpdateCatalogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCatalogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCatalogResponse> transformer = UpdateCatalogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCatalogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCatalogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCatalogDetails(), (BmcRequest)retriedRequest);
                return (UpdateCatalogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCatalogPrivateEndpointResponse updateCatalogPrivateEndpoint(UpdateCatalogPrivateEndpointRequest request) {
        LOG.trace("Called updateCatalogPrivateEndpoint");
        UpdateCatalogPrivateEndpointRequest interceptedRequest = UpdateCatalogPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCatalogPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCatalogPrivateEndpointResponse> transformer = UpdateCatalogPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCatalogPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCatalogPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCatalogPrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (UpdateCatalogPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        LOG.trace("Called updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConnectionDetails(), (BmcRequest)retriedRequest);
                return (UpdateConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCustomPropertyResponse updateCustomProperty(UpdateCustomPropertyRequest request) {
        LOG.trace("Called updateCustomProperty");
        UpdateCustomPropertyRequest interceptedRequest = UpdateCustomPropertyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomPropertyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCustomPropertyResponse> transformer = UpdateCustomPropertyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCustomPropertyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCustomPropertyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCustomPropertyDetails(), (BmcRequest)retriedRequest);
                return (UpdateCustomPropertyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDataAssetResponse updateDataAsset(UpdateDataAssetRequest request) {
        LOG.trace("Called updateDataAsset");
        UpdateDataAssetRequest interceptedRequest = UpdateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDataAssetResponse> transformer = UpdateDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDataAssetDetails(), (BmcRequest)retriedRequest);
                return (UpdateDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateEntityResponse updateEntity(UpdateEntityRequest request) {
        LOG.trace("Called updateEntity");
        UpdateEntityRequest interceptedRequest = UpdateEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateEntityResponse> transformer = UpdateEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateEntityDetails(), (BmcRequest)retriedRequest);
                return (UpdateEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest request) {
        LOG.trace("Called updateFolder");
        UpdateFolderRequest interceptedRequest = UpdateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFolderResponse> transformer = UpdateFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateFolderDetails(), (BmcRequest)retriedRequest);
                return (UpdateFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateGlossaryResponse updateGlossary(UpdateGlossaryRequest request) {
        LOG.trace("Called updateGlossary");
        UpdateGlossaryRequest interceptedRequest = UpdateGlossaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGlossaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateGlossaryResponse> transformer = UpdateGlossaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateGlossaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateGlossaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateGlossaryDetails(), (BmcRequest)retriedRequest);
                return (UpdateGlossaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        LOG.trace("Called updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateJobDefinitionResponse updateJobDefinition(UpdateJobDefinitionRequest request) {
        LOG.trace("Called updateJobDefinition");
        UpdateJobDefinitionRequest interceptedRequest = UpdateJobDefinitionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobDefinitionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobDefinitionResponse> transformer = UpdateJobDefinitionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateJobDefinitionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobDefinitionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobDefinitionDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobDefinitionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNamespaceResponse updateNamespace(UpdateNamespaceRequest request) {
        LOG.trace("Called updateNamespace");
        UpdateNamespaceRequest interceptedRequest = UpdateNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNamespaceResponse> transformer = UpdateNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNamespaceDetails(), (BmcRequest)retriedRequest);
                return (UpdateNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePatternResponse updatePattern(UpdatePatternRequest request) {
        LOG.trace("Called updatePattern");
        UpdatePatternRequest interceptedRequest = UpdatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePatternConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePatternResponse> transformer = UpdatePatternConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdatePatternResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePatternResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePatternDetails(), (BmcRequest)retriedRequest);
                return (UpdatePatternResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTermResponse updateTerm(UpdateTermRequest request) {
        LOG.trace("Called updateTerm");
        UpdateTermRequest interceptedRequest = UpdateTermConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTermConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTermResponse> transformer = UpdateTermConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTermResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTermResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTermDetails(), (BmcRequest)retriedRequest);
                return (UpdateTermResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTermRelationshipResponse updateTermRelationship(UpdateTermRelationshipRequest request) {
        LOG.trace("Called updateTermRelationship");
        UpdateTermRelationshipRequest interceptedRequest = UpdateTermRelationshipConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTermRelationshipConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTermRelationshipResponse> transformer = UpdateTermRelationshipConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTermRelationshipResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTermRelationshipResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTermRelationshipDetails(), (BmcRequest)retriedRequest);
                return (UpdateTermRelationshipResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UploadCredentialsResponse uploadCredentials(UploadCredentialsRequest request) {
        LOG.trace("Called uploadCredentials");
        UploadCredentialsRequest interceptedRequest = UploadCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UploadCredentialsResponse> transformer = UploadCredentialsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UploadCredentialsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UploadCredentialsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUploadCredentialsDetails(), (BmcRequest)retriedRequest);
                return (UploadCredentialsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UsersResponse users(UsersRequest request) {
        LOG.trace("Called users");
        UsersRequest interceptedRequest = UsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UsersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UsersResponse> transformer = UsersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UsersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UsersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (UsersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateConnectionResponse validateConnection(ValidateConnectionRequest request) {
        LOG.trace("Called validateConnection");
        ValidateConnectionRequest interceptedRequest = ValidateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateConnectionResponse> transformer = ValidateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ValidateConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getValidateConnectionDetails(), (BmcRequest)retriedRequest);
                return (ValidateConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidatePatternResponse validatePattern(ValidatePatternRequest request) {
        LOG.trace("Called validatePattern");
        ValidatePatternRequest interceptedRequest = ValidatePatternConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidatePatternConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidatePatternResponse> transformer = ValidatePatternConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ValidatePatternResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidatePatternResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getValidatePatternDetails(), (BmcRequest)retriedRequest);
                return (ValidatePatternResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DataCatalogWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataCatalogPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataCatalogClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataCatalogClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataCatalogClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

