/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.AttributeCollection;
import com.oracle.bmc.datacatalog.requests.ListAttributesRequest;
import com.oracle.bmc.datacatalog.responses.ListAttributesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAttributesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAttributesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAttributesRequest interceptRequest(ListAttributesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAttributesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("dataAssets").path(HttpUtils.encodePathSegment((String)request.getDataAssetKey())).path("entities").path(HttpUtils.encodePathSegment((String)request.getEntityKey())).path("attributes");
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getDisplayNameContains() != null) {
            target = target.queryParam("displayNameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayNameContains())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getTimeCreated() != null) {
            target = target.queryParam("timeCreated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreated())});
        }
        if (request.getTimeUpdated() != null) {
            target = target.queryParam("timeUpdated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeUpdated())});
        }
        if (request.getCreatedById() != null) {
            target = target.queryParam("createdById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreatedById())});
        }
        if (request.getUpdatedById() != null) {
            target = target.queryParam("updatedById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUpdatedById())});
        }
        if (request.getExternalKey() != null) {
            target = target.queryParam("externalKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getExternalKey())});
        }
        if (request.getTimeExternal() != null) {
            target = target.queryParam("timeExternal", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeExternal())});
        }
        if (request.getExternalTypeName() != null) {
            target = target.queryParam("externalTypeName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getExternalTypeName())});
        }
        if (request.getIsIncrementalData() != null) {
            target = target.queryParam("isIncrementalData", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsIncrementalData())});
        }
        if (request.getIsNullable() != null) {
            target = target.queryParam("isNullable", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsNullable())});
        }
        if (request.getLength() != null) {
            target = target.queryParam("length", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLength())});
        }
        if (request.getPosition() != null) {
            target = target.queryParam("position", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPosition())});
        }
        if (request.getPrecision() != null) {
            target = target.queryParam("precision", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPrecision())});
        }
        if (request.getScale() != null) {
            target = target.queryParam("scale", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getScale())});
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListAttributesResponse> fromResponse() {
        Function<Response, ListAttributesResponse> transformer = new Function<Response, ListAttributesResponse>(){

            public ListAttributesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ListAttributesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AttributeCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListAttributesResponse.Builder builder = ListAttributesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.attributeCollection((AttributeCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListAttributesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

