/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.RecommendationCollection;
import com.oracle.bmc.datacatalog.requests.RecommendationsRequest;
import com.oracle.bmc.datacatalog.responses.RecommendationsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendationsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RecommendationsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RecommendationsRequest interceptRequest(RecommendationsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RecommendationsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notNull(request.getRecommendationType(), (String)"recommendationType is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getSourceObjectKey(), (String)"sourceObjectKey is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getSourceObjectType()), (String)"sourceObjectType is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("actions").path("getRecommendations");
        target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"recommendationType", request.getRecommendationType(), (CollectionFormatType)CollectionFormatType.Multi);
        target = target.queryParam("sourceObjectKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceObjectKey())});
        target = target.queryParam("sourceObjectType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceObjectType().getValue())});
        if (request.getRecommendationStatus() != null) {
            target = target.queryParam("recommendationStatus", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRecommendationStatus().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RecommendationsResponse> fromResponse() {
        Function<Response, RecommendationsResponse> transformer = new Function<Response, RecommendationsResponse>(){

            public RecommendationsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.RecommendationsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RecommendationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RecommendationsResponse.Builder builder = RecommendationsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.recommendationCollection((RecommendationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RecommendationsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

