/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.ValidatePatternResult;
import com.oracle.bmc.datacatalog.requests.ValidatePatternRequest;
import com.oracle.bmc.datacatalog.responses.ValidatePatternResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatePatternConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatePatternConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ValidatePatternRequest interceptRequest(ValidatePatternRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ValidatePatternRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getValidatePatternDetails(), (String)"validatePatternDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("patterns").path(HttpUtils.encodePathSegment((String)request.getPatternKey())).path("actions").path("validate");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ValidatePatternResponse> fromResponse() {
        Function<Response, ValidatePatternResponse> transformer = new Function<Response, ValidatePatternResponse>(){

            public ValidatePatternResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ValidatePatternResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ValidatePatternResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ValidatePatternResponse.Builder builder = ValidatePatternResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.validatePatternResult((ValidatePatternResult)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ValidatePatternResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

