/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateAttributeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateAttributeRequest
extends BmcRequest<CreateAttributeDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private CreateAttributeDetails createAttributeDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateAttributeDetails getBody$() {
        return this.createAttributeDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "createAttributeDetails", "opcRequestId", "opcRetryToken"})
    CreateAttributeRequest(String catalogId, String dataAssetKey, String entityKey, CreateAttributeDetails createAttributeDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.createAttributeDetails = createAttributeDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public CreateAttributeDetails getCreateAttributeDetails() {
        return this.createAttributeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAttributeRequest, CreateAttributeDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private CreateAttributeDetails createAttributeDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAttributeRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.createAttributeDetails(o.getCreateAttributeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAttributeRequest build() {
            CreateAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateAttributeDetails body) {
            this.createAttributeDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder createAttributeDetails(CreateAttributeDetails createAttributeDetails) {
            this.createAttributeDetails = createAttributeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateAttributeRequest buildWithoutInvocationCallback() {
            return new CreateAttributeRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.createAttributeDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateAttributeRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", createAttributeDetails=" + this.createAttributeDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

