/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateEntityDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateEntityRequest
extends BmcRequest<CreateEntityDetails> {
    private String catalogId;
    private String dataAssetKey;
    private CreateEntityDetails createEntityDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateEntityDetails getBody$() {
        return this.createEntityDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "createEntityDetails", "opcRequestId", "opcRetryToken"})
    CreateEntityRequest(String catalogId, String dataAssetKey, CreateEntityDetails createEntityDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.createEntityDetails = createEntityDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public CreateEntityDetails getCreateEntityDetails() {
        return this.createEntityDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateEntityRequest, CreateEntityDetails> {
        private String catalogId;
        private String dataAssetKey;
        private CreateEntityDetails createEntityDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateEntityRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.createEntityDetails(o.getCreateEntityDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateEntityRequest build() {
            CreateEntityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateEntityDetails body) {
            this.createEntityDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder createEntityDetails(CreateEntityDetails createEntityDetails) {
            this.createEntityDetails = createEntityDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateEntityRequest buildWithoutInvocationCallback() {
            return new CreateEntityRequest(this.catalogId, this.dataAssetKey, this.createEntityDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateEntityRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", createEntityDetails=" + this.createEntityDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

