/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreatePatternDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreatePatternRequest
extends BmcRequest<CreatePatternDetails> {
    private String catalogId;
    private CreatePatternDetails createPatternDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreatePatternDetails getBody$() {
        return this.createPatternDetails;
    }

    @ConstructorProperties(value={"catalogId", "createPatternDetails", "opcRequestId", "opcRetryToken"})
    CreatePatternRequest(String catalogId, CreatePatternDetails createPatternDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.createPatternDetails = createPatternDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public CreatePatternDetails getCreatePatternDetails() {
        return this.createPatternDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePatternRequest, CreatePatternDetails> {
        private String catalogId;
        private CreatePatternDetails createPatternDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePatternRequest o) {
            this.catalogId(o.getCatalogId());
            this.createPatternDetails(o.getCreatePatternDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePatternRequest build() {
            CreatePatternRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePatternDetails body) {
            this.createPatternDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder createPatternDetails(CreatePatternDetails createPatternDetails) {
            this.createPatternDetails = createPatternDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreatePatternRequest buildWithoutInvocationCallback() {
            return new CreatePatternRequest(this.catalogId, this.createPatternDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreatePatternRequest.Builder(catalogId=" + this.catalogId + ", createPatternDetails=" + this.createPatternDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

