/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteNamespaceRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String namespaceId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "namespaceId", "ifMatch", "opcRequestId"})
    DeleteNamespaceRequest(String catalogId, String namespaceId, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.namespaceId = namespaceId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteNamespaceRequest, Void> {
        private String catalogId;
        private String namespaceId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNamespaceRequest o) {
            this.catalogId(o.getCatalogId());
            this.namespaceId(o.getNamespaceId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNamespaceRequest build() {
            DeleteNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteNamespaceRequest buildWithoutInvocationCallback() {
            return new DeleteNamespaceRequest(this.catalogId, this.namespaceId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteNamespaceRequest.Builder(catalogId=" + this.catalogId + ", namespaceId=" + this.namespaceId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

