/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetGlossaryRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String glossaryKey;
    private List<Fields> fields;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "glossaryKey", "fields", "opcRequestId"})
    GetGlossaryRequest(String catalogId, String glossaryKey, List<Fields> fields, String opcRequestId) {
        this.catalogId = catalogId;
        this.glossaryKey = glossaryKey;
        this.fields = fields;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGlossaryRequest, Void> {
        private String catalogId;
        private String glossaryKey;
        private List<Fields> fields;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGlossaryRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGlossaryRequest build() {
            GetGlossaryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetGlossaryRequest buildWithoutInvocationCallback() {
            return new GetGlossaryRequest(this.catalogId, this.glossaryKey, this.fields, this.opcRequestId);
        }

        public String toString() {
            return "GetGlossaryRequest.Builder(catalogId=" + this.catalogId + ", glossaryKey=" + this.glossaryKey + ", fields=" + this.fields + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum Fields {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        CatalogId("catalogId"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        CreatedById("createdById"),
        UpdatedById("updatedById"),
        Owner("owner"),
        WorkflowStatus("workflowStatus"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

