/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ImportConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ImportConnectionRequest
extends BmcRequest<ImportConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ImportConnectionDetails importConnectionDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    @InternalSdk
    public ImportConnectionDetails getBody$() {
        return this.importConnectionDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "importConnectionDetails", "opcRequestId", "ifMatch", "opcRetryToken"})
    ImportConnectionRequest(String catalogId, String dataAssetKey, ImportConnectionDetails importConnectionDetails, String opcRequestId, String ifMatch, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.importConnectionDetails = importConnectionDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ImportConnectionDetails getImportConnectionDetails() {
        return this.importConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportConnectionRequest, ImportConnectionDetails> {
        private String catalogId;
        private String dataAssetKey;
        private ImportConnectionDetails importConnectionDetails;
        private String opcRequestId;
        private String ifMatch;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.importConnectionDetails(o.getImportConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportConnectionRequest build() {
            ImportConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportConnectionDetails body) {
            this.importConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder importConnectionDetails(ImportConnectionDetails importConnectionDetails) {
            this.importConnectionDetails = importConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ImportConnectionRequest buildWithoutInvocationCallback() {
            return new ImportConnectionRequest(this.catalogId, this.dataAssetKey, this.importConnectionDetails, this.opcRequestId, this.ifMatch, this.opcRetryToken);
        }

        public String toString() {
            return "ImportConnectionRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", importConnectionDetails=" + this.importConnectionDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

