/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAttributesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private String displayName;
    private String displayNameContains;
    private LifecycleState lifecycleState;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private String externalKey;
    private Date timeExternal;
    private String externalTypeName;
    private Boolean isIncrementalData;
    private Boolean isNullable;
    private Long length;
    private Integer position;
    private Integer precision;
    private Integer scale;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "displayName", "displayNameContains", "lifecycleState", "timeCreated", "timeUpdated", "createdById", "updatedById", "externalKey", "timeExternal", "externalTypeName", "isIncrementalData", "isNullable", "length", "position", "precision", "scale", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListAttributesRequest(String catalogId, String dataAssetKey, String entityKey, String displayName, String displayNameContains, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, String createdById, String updatedById, String externalKey, Date timeExternal, String externalTypeName, Boolean isIncrementalData, Boolean isNullable, Long length, Integer position, Integer precision, Integer scale, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.externalKey = externalKey;
        this.timeExternal = timeExternal;
        this.externalTypeName = externalTypeName;
        this.isIncrementalData = isIncrementalData;
        this.isNullable = isNullable;
        this.length = length;
        this.position = position;
        this.precision = precision;
        this.scale = scale;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Date getTimeExternal() {
        return this.timeExternal;
    }

    public String getExternalTypeName() {
        return this.externalTypeName;
    }

    public Boolean getIsIncrementalData() {
        return this.isIncrementalData;
    }

    public Boolean getIsNullable() {
        return this.isNullable;
    }

    public Long getLength() {
        return this.length;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAttributesRequest, Void> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private String displayName;
        private String displayNameContains;
        private LifecycleState lifecycleState;
        private Date timeCreated;
        private Date timeUpdated;
        private String createdById;
        private String updatedById;
        private String externalKey;
        private Date timeExternal;
        private String externalTypeName;
        private Boolean isIncrementalData;
        private Boolean isNullable;
        private Long length;
        private Integer position;
        private Integer precision;
        private Integer scale;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAttributesRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.externalKey(o.getExternalKey());
            this.timeExternal(o.getTimeExternal());
            this.externalTypeName(o.getExternalTypeName());
            this.isIncrementalData(o.getIsIncrementalData());
            this.isNullable(o.getIsNullable());
            this.length(o.getLength());
            this.position(o.getPosition());
            this.precision(o.getPrecision());
            this.scale(o.getScale());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAttributesRequest build() {
            ListAttributesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            return this;
        }

        public Builder timeExternal(Date timeExternal) {
            this.timeExternal = timeExternal;
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            return this;
        }

        public Builder isIncrementalData(Boolean isIncrementalData) {
            this.isIncrementalData = isIncrementalData;
            return this;
        }

        public Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder length(Long length) {
            this.length = length;
            return this;
        }

        public Builder position(Integer position) {
            this.position = position;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListAttributesRequest buildWithoutInvocationCallback() {
            return new ListAttributesRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.displayName, this.displayNameContains, this.lifecycleState, this.timeCreated, this.timeUpdated, this.createdById, this.updatedById, this.externalKey, this.timeExternal, this.externalTypeName, this.isIncrementalData, this.isNullable, this.length, this.position, this.precision, this.scale, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListAttributesRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", createdById=" + this.createdById + ", updatedById=" + this.updatedById + ", externalKey=" + this.externalKey + ", timeExternal=" + this.timeExternal + ", externalTypeName=" + this.externalTypeName + ", isIncrementalData=" + this.isIncrementalData + ", isNullable=" + this.isNullable + ", length=" + this.length + ", position=" + this.position + ", precision=" + this.precision + ", scale=" + this.scale + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        EntityKey("entityKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        ExternalDataType("externalDataType"),
        ExternalKey("externalKey"),
        Length("length"),
        Precision("precision"),
        Scale("scale"),
        IsNullable("isNullable"),
        Uri("uri"),
        Path("path"),
        MinCollectionCount("minCollectionCount"),
        MaxCollectionCount("maxCollectionCount"),
        DatatypeEntityKey("datatypeEntityKey"),
        ExternalDatatypeEntityKey("externalDatatypeEntityKey"),
        ParentAttributeKey("parentAttributeKey"),
        ExternalParentAttributeKey("externalParentAttributeKey");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

