/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListJobMetricsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private String jobExecutionKey;
    private String displayName;
    private String displayNameContains;
    private String category;
    private String subCategory;
    private String unit;
    private String value;
    private String batchKey;
    private Date timeCreated;
    private Date timeUpdated;
    private Date timeInserted;
    private String createdById;
    private String updatedById;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "jobKey", "jobExecutionKey", "displayName", "displayNameContains", "category", "subCategory", "unit", "value", "batchKey", "timeCreated", "timeUpdated", "timeInserted", "createdById", "updatedById", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListJobMetricsRequest(String catalogId, String jobKey, String jobExecutionKey, String displayName, String displayNameContains, String category, String subCategory, String unit, String value, String batchKey, Date timeCreated, Date timeUpdated, Date timeInserted, String createdById, String updatedById, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.jobKey = jobKey;
        this.jobExecutionKey = jobExecutionKey;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.category = category;
        this.subCategory = subCategory;
        this.unit = unit;
        this.value = value;
        this.batchKey = batchKey;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeInserted = timeInserted;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getValue() {
        return this.value;
    }

    public String getBatchKey() {
        return this.batchKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeInserted() {
        return this.timeInserted;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobMetricsRequest, Void> {
        private String catalogId;
        private String jobKey;
        private String jobExecutionKey;
        private String displayName;
        private String displayNameContains;
        private String category;
        private String subCategory;
        private String unit;
        private String value;
        private String batchKey;
        private Date timeCreated;
        private Date timeUpdated;
        private Date timeInserted;
        private String createdById;
        private String updatedById;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobMetricsRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.jobExecutionKey(o.getJobExecutionKey());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.category(o.getCategory());
            this.subCategory(o.getSubCategory());
            this.unit(o.getUnit());
            this.value(o.getValue());
            this.batchKey(o.getBatchKey());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.timeInserted(o.getTimeInserted());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobMetricsRequest build() {
            ListJobMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder batchKey(String batchKey) {
            this.batchKey = batchKey;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder timeInserted(Date timeInserted) {
            this.timeInserted = timeInserted;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListJobMetricsRequest buildWithoutInvocationCallback() {
            return new ListJobMetricsRequest(this.catalogId, this.jobKey, this.jobExecutionKey, this.displayName, this.displayNameContains, this.category, this.subCategory, this.unit, this.value, this.batchKey, this.timeCreated, this.timeUpdated, this.timeInserted, this.createdById, this.updatedById, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListJobMetricsRequest.Builder(catalogId=" + this.catalogId + ", jobKey=" + this.jobKey + ", jobExecutionKey=" + this.jobExecutionKey + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", category=" + this.category + ", subCategory=" + this.subCategory + ", unit=" + this.unit + ", value=" + this.value + ", batchKey=" + this.batchKey + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", timeInserted=" + this.timeInserted + ", createdById=" + this.createdById + ", updatedById=" + this.updatedById + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        Description("description"),
        DisplayName("displayName"),
        TimeInserted("timeInserted"),
        Category("category"),
        SubCategory("subCategory"),
        Unit("unit"),
        Value("value"),
        BatchKey("batchKey"),
        JobExecutionKey("jobExecutionKey"),
        TimeCreated("timeCreated"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

