/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ProcessRecommendationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ProcessRecommendationRequest
extends BmcRequest<ProcessRecommendationDetails> {
    private String catalogId;
    private ProcessRecommendationDetails processRecommendationDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public ProcessRecommendationDetails getBody$() {
        return this.processRecommendationDetails;
    }

    @ConstructorProperties(value={"catalogId", "processRecommendationDetails", "ifMatch", "opcRequestId"})
    ProcessRecommendationRequest(String catalogId, ProcessRecommendationDetails processRecommendationDetails, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.processRecommendationDetails = processRecommendationDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public ProcessRecommendationDetails getProcessRecommendationDetails() {
        return this.processRecommendationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ProcessRecommendationRequest, ProcessRecommendationDetails> {
        private String catalogId;
        private ProcessRecommendationDetails processRecommendationDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ProcessRecommendationRequest o) {
            this.catalogId(o.getCatalogId());
            this.processRecommendationDetails(o.getProcessRecommendationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ProcessRecommendationRequest build() {
            ProcessRecommendationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ProcessRecommendationDetails body) {
            this.processRecommendationDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder processRecommendationDetails(ProcessRecommendationDetails processRecommendationDetails) {
            this.processRecommendationDetails = processRecommendationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ProcessRecommendationRequest buildWithoutInvocationCallback() {
            return new ProcessRecommendationRequest(this.catalogId, this.processRecommendationDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "ProcessRecommendationRequest.Builder(catalogId=" + this.catalogId + ", processRecommendationDetails=" + this.processRecommendationDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

